/*
 * Decompiled with CFR 0.152.
 */
package GraphServer;

import GraphServer.Connection;
import GraphServer.GraphServer;
import GraphServer.Player;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;

public class ClientConnection
implements Runnable {
    private Connection connection;
    private List<Player> players;
    private GraphServer server;
    private boolean running;
    private boolean leader;
    private boolean readyNextTurn;
    private boolean gameFinished;
    private boolean skipLevel;

    public ClientConnection(GraphServer graphServer, Socket socket) throws IOException {
        this.server = graphServer;
        this.connection = new Connection(socket);
        this.players = new ArrayList<Player>();
        this.running = false;
        this.leader = false;
        this.readyNextTurn = false;
        this.gameFinished = false;
        this.skipLevel = false;
    }

    public List<Player> getPlayers() {
        return this.players;
    }

    public boolean isLeader() {
        return this.leader;
    }

    public void setLeader(boolean bl) {
        this.leader = bl;
    }

    public boolean getSkipLevel() {
        return this.skipLevel;
    }

    public void setSkipLevel(boolean bl) {
        this.skipLevel = bl;
    }

    public boolean isFinished() {
        return this.gameFinished;
    }

    public void setFinished(boolean bl) {
        this.gameFinished = bl;
    }

    public void removePlayer(Player player) {
        this.players.remove(player);
    }

    public void addPlayer(Player player) {
        this.players.add(player);
    }

    public boolean getReadyNextTurn() {
        return this.readyNextTurn;
    }

    public void setReadyNextTurn(boolean bl) {
        this.readyNextTurn = bl;
    }

    public boolean checkTimeout() {
        return System.currentTimeMillis() - this.connection.getLastReceivedTime() > 30000L;
    }

    public boolean checkStayAliveTime() {
        return System.currentTimeMillis() - this.connection.getLastSentTime() > 5000L;
    }

    public void disconnect() {
        this.running = false;
        try {
            this.connection.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void sendMessage(String string) {
        this.connection.sendMessage(string);
    }

    public void sendKeepAlive() {
        this.connection.sendMessage("10");
    }

    @Override
    public void run() {
        this.running = true;
        while (this.running) {
            try {
                String string = this.connection.readMessage();
                if (string == null) {
                    this.server.removeClient(this);
                    this.disconnect();
                    continue;
                }
                this.server.handleMessage(string, this);
                if (!this.checkStayAliveTime()) continue;
                this.sendKeepAlive();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                if (this.checkTimeout()) {
                    this.server.removeClient(this);
                    this.disconnect();
                    continue;
                }
                this.sendKeepAlive();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.server.removeClient(this);
                this.disconnect();
            }
        }
    }
}

