/*
 * Decompiled with CFR 0.152.
 */
package GraphServer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;

public class Connection {
    private Socket socket;
    private PrintWriter out;
    private BufferedReader in;
    private long lastReceivedTime;
    private long lastSentTime;

    public Connection(String string, int n) throws IOException {
        InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
        this.socket = new Socket();
        this.socket.connect(inetSocketAddress, 10000);
        this.socket.setSoTimeout(5000);
        this.out = new PrintWriter(this.socket.getOutputStream(), true);
        this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        this.lastReceivedTime = System.currentTimeMillis();
        this.lastSentTime = System.currentTimeMillis();
    }

    public Connection(Socket socket) throws IOException {
        this.socket = socket;
        socket.setSoTimeout(5000);
        this.out = new PrintWriter(socket.getOutputStream(), true);
        this.in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
    }

    public void close() throws IOException {
        this.out.close();
        this.in.close();
        this.socket.close();
    }

    public String getIpAddress() {
        return this.socket.getInetAddress().getHostAddress();
    }

    public long getLastSentTime() {
        return this.lastSentTime;
    }

    public long getLastReceivedTime() {
        return this.lastReceivedTime;
    }

    public void sendMessage(String string) {
        this.out.println(string);
        this.lastSentTime = System.currentTimeMillis();
    }

    public String readMessage() throws IOException {
        String string = null;
        string = this.in.readLine();
        this.lastReceivedTime = System.currentTimeMillis();
        return string;
    }
}

