/*
 * Decompiled with CFR 0.152.
 */
package GraphServer;

import GraphServer.ClientConnection;
import GraphServer.Player;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;

public class GraphServer
implements Runnable {
    private int port;
    private ServerSocket serverSocket;
    protected List<ClientConnection> clients = new ArrayList<ClientConnection>();
    protected List<Player> players = new ArrayList<Player>();
    protected boolean acceptingConnections;
    protected int gameMode;
    protected int gameState;
    private boolean countingDown;
    StartDelayer startDelayer;
    private long timeTurnStarted;
    private static Random random = new Random();

    public GraphServer(int n) throws IOException {
        this.port = n;
        this.serverSocket = new ServerSocket(n);
        this.gameMode = 0;
        this.gameState = 1;
        this.countingDown = false;
        this.startDelayer = null;
        this.acceptingConnections = true;
    }

    public GraphServer() throws IOException {
        this.serverSocket = new ServerSocket(0);
        this.port = this.serverSocket.getLocalPort();
        this.gameMode = 0;
        this.gameState = 1;
        this.countingDown = false;
        this.startDelayer = null;
        this.acceptingConnections = true;
    }

    public void finalize() {
        String string = "39";
        this.sendMessageAll(string);
        ListIterator<ClientConnection> listIterator = this.clients.listIterator();
        while (listIterator.hasNext()) {
            ClientConnection clientConnection = listIterator.next();
            clientConnection.disconnect();
        }
        this.acceptingConnections = false;
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public synchronized void addClient(Socket socket) {
        if (this.clients.size() < 10) {
            try {
                ClientConnection clientConnection = new ClientConnection(this, socket);
                if (this.clients.size() == 0) {
                    clientConnection.setLeader(true);
                }
                this.clients.add(clientConnection);
                new Thread(clientConnection).start();
                this.sendAllInfoMessage(clientConnection);
                if (clientConnection.isLeader()) {
                    this.sendLeaderMessage(clientConnection);
                }
            }
            catch (IOException iOException) {
                System.out.println("Adding new client failed.");
                iOException.printStackTrace();
            }
        } else {
            try {
                ClientConnection clientConnection = new ClientConnection(this, socket);
                String string = "38";
                clientConnection.sendMessage(string);
                clientConnection.disconnect();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public void run() {
        this.acceptingConnections = true;
        while (this.acceptingConnections) {
            try {
                Socket socket = this.serverSocket.accept();
                if (this.acceptingConnections) {
                    this.addClient(socket);
                    continue;
                }
                ClientConnection clientConnection = new ClientConnection(this, socket);
                String string = "38";
                clientConnection.sendMessage(string);
                clientConnection.disconnect();
            }
            catch (IOException iOException) {}
        }
    }

    private void sendMessageAll(String string) {
        ListIterator<ClientConnection> listIterator = this.clients.listIterator();
        while (listIterator.hasNext()) {
            ClientConnection clientConnection = listIterator.next();
            clientConnection.sendMessage(string);
        }
    }

    private void sendLeaderMessage(ClientConnection clientConnection) {
        String string = "41";
        clientConnection.sendMessage(string);
    }

    private void sendAllInfoMessage(ClientConnection clientConnection) {
        Object object;
        ListIterator<ClientConnection> listIterator = this.clients.listIterator();
        while (listIterator.hasNext()) {
            object = listIterator.next();
            List<Player> list = ((ClientConnection)object).getPlayers();
            ListIterator<Player> listIterator2 = list.listIterator();
            while (listIterator2.hasNext()) {
                Player player = listIterator2.next();
                int n = 0;
                if (clientConnection == object) {
                    n = 1;
                }
                int n2 = 0;
                if (player.getReady()) {
                    n2 = 1;
                }
                String string = "16&" + player.getID() + "&" + player.getName() + "&" + player.getTeam() + "&" + n + "&" + player.getNumSoldiers() + "&" + n2;
                clientConnection.sendMessage(string);
            }
        }
        object = "33&" + this.gameMode;
        clientConnection.sendMessage((String)object);
    }

    protected void sendAddPlayerMessage(Player player, ClientConnection clientConnection) {
        ListIterator<ClientConnection> listIterator = this.clients.listIterator();
        while (listIterator.hasNext()) {
            ClientConnection clientConnection2 = listIterator.next();
            int n = 0;
            if (clientConnection2 == clientConnection) {
                n = 1;
            }
            int n2 = 0;
            if (player.getReady()) {
                n2 = 1;
            }
            String string = "16&" + player.getID() + "&" + player.getName() + "&" + player.getTeam() + "&" + n + "&" + player.getNumSoldiers() + "&" + n2;
            clientConnection2.sendMessage(string);
        }
    }

    private boolean setTeam(int n, int n2, ClientConnection clientConnection) {
        Object object;
        List<Player> list = clientConnection.getPlayers();
        ListIterator<Player> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            object = listIterator.next();
            if (((Player)object).getID() != n2) continue;
            ((Player)object).setTeam(n);
            return true;
        }
        if (clientConnection.isLeader()) {
            object = this.clients.listIterator();
            while (object.hasNext()) {
                ClientConnection clientConnection2 = (ClientConnection)object.next();
                List<Player> list2 = clientConnection2.getPlayers();
                ListIterator<Player> listIterator2 = list2.listIterator();
                while (listIterator2.hasNext()) {
                    Player player = listIterator2.next();
                    if (player.getID() != n2) continue;
                    player.setTeam(n);
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean removePlayer(int n, ClientConnection clientConnection) {
        Object object;
        List<Player> list = clientConnection.getPlayers();
        ListIterator<Player> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            object = listIterator.next();
            if (((Player)object).getID() != n) continue;
            clientConnection.removePlayer((Player)object);
            this.players.remove(object);
            return true;
        }
        if (clientConnection.isLeader()) {
            object = this.clients.listIterator();
            while (object.hasNext()) {
                ClientConnection clientConnection2 = (ClientConnection)object.next();
                List<Player> list2 = clientConnection2.getPlayers();
                ListIterator<Player> listIterator2 = list2.listIterator();
                while (listIterator2.hasNext()) {
                    Player player = listIterator2.next();
                    if (player.getID() != n) continue;
                    clientConnection2.removePlayer(player);
                    this.players.remove(player);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean setReady(int n, ClientConnection clientConnection, boolean bl) {
        List<Player> list = clientConnection.getPlayers();
        ListIterator<Player> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Player player = listIterator.next();
            if (player.getID() != n) continue;
            player.setReady(bl);
            if (!bl && this.startDelayer != null) {
                this.startDelayer.stop();
            }
            return true;
        }
        return false;
    }

    private boolean addSoldier(int n, ClientConnection clientConnection) {
        Object object;
        List<Player> list = clientConnection.getPlayers();
        ListIterator<Player> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            object = listIterator.next();
            if (((Player)object).getID() != n) continue;
            int n2 = ((Player)object).getNumSoldiers() + 1;
            if (n2 > 4) break;
            ((Player)object).setNumSoldiers(n2);
            return true;
        }
        if (clientConnection.isLeader()) {
            object = this.clients.listIterator();
            block1: while (object.hasNext()) {
                ClientConnection clientConnection2 = (ClientConnection)object.next();
                list = clientConnection2.getPlayers();
                ListIterator<Player> listIterator2 = list.listIterator();
                while (listIterator2.hasNext()) {
                    Player player = listIterator2.next();
                    if (player.getID() != n) continue;
                    int n3 = player.getNumSoldiers() + 1;
                    if (n3 > 4) continue block1;
                    player.setNumSoldiers(n3);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean removeSoldier(int n, ClientConnection clientConnection) {
        Object object;
        List<Player> list = clientConnection.getPlayers();
        ListIterator<Player> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            object = listIterator.next();
            if (((Player)object).getID() != n) continue;
            int n2 = ((Player)object).getNumSoldiers() - 1;
            if (n2 < 0) break;
            ((Player)object).setNumSoldiers(n2);
            return true;
        }
        if (clientConnection.isLeader()) {
            object = this.clients.listIterator();
            block1: while (object.hasNext()) {
                ClientConnection clientConnection2 = (ClientConnection)object.next();
                list = clientConnection2.getPlayers();
                ListIterator<Player> listIterator2 = list.listIterator();
                while (listIterator2.hasNext()) {
                    Player player = listIterator2.next();
                    if (player.getID() != n) continue;
                    int n3 = player.getNumSoldiers() - 1;
                    if (n3 < 0) continue block1;
                    player.setNumSoldiers(n3);
                    return true;
                }
            }
        }
        return false;
    }

    private void setEveryoneNotReady() {
        if (this.startDelayer != null) {
            this.startDelayer.stop();
        }
        ListIterator<ClientConnection> listIterator = this.clients.listIterator();
        while (listIterator.hasNext()) {
            ClientConnection clientConnection = listIterator.next();
            List<Player> list = clientConnection.getPlayers();
            ListIterator<Player> listIterator2 = list.listIterator();
            while (listIterator2.hasNext()) {
                Player player = listIterator2.next();
                if (!player.getReady()) continue;
                player.setReady(false);
                String string = "21&" + player.getID() + "&" + 0;
                this.sendMessageAll(string);
            }
        }
    }

    private boolean checkPlayer(int n, ClientConnection clientConnection) {
        List<Player> list = clientConnection.getPlayers();
        ListIterator<Player> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Player player = listIterator.next();
            if (player.getID() != n) continue;
            return true;
        }
        return false;
    }

    protected void sendModeMessage() {
        String string = "33&" + this.gameMode;
        this.sendMessageAll(string);
    }

    private boolean checkAllReady() {
        ListIterator<ClientConnection> listIterator = this.clients.listIterator();
        while (listIterator.hasNext()) {
            ClientConnection clientConnection = listIterator.next();
            List<Player> list = clientConnection.getPlayers();
            ListIterator<Player> listIterator2 = list.listIterator();
            while (listIterator2.hasNext()) {
                Player player = listIterator2.next();
                if (player.getReady()) continue;
                return false;
            }
        }
        return true;
    }

    public void removeClient(ClientConnection clientConnection) {
        this.clients.remove(clientConnection);
        List<Player> list = clientConnection.getPlayers();
        ListIterator<Player> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Player player = listIterator.next();
            String string = "29&" + player.getID();
            this.sendMessageAll(string);
            this.players.remove(player);
        }
        if (!this.clients.isEmpty() && clientConnection.isLeader()) {
            this.clients.get(0).setLeader(true);
            this.sendLeaderMessage(this.clients.get(0));
        }
        this.checkNextTurn();
    }

    private int[] generateCircles() {
        int n = (int)(random.nextGaussian() * 7.0 + 15.0);
        if (n < 1) {
            n = 1;
        }
        int[] nArray = new int[3 * n];
        for (int i = 0; i < n; ++i) {
            nArray[3 * i] = random.nextInt(770);
            nArray[3 * i + 1] = random.nextInt(450);
            nArray[3 * i + 2] = (int)(random.nextGaussian() * 25.0 + 40.0);
            while (nArray[3 * i + 2] < 0) {
                nArray[3 * i + 2] = (int)(random.nextGaussian() * 25.0 + 40.0);
            }
        }
        return nArray;
    }

    private double distance(int n, int n2, int n3, int n4) {
        double d = Math.sqrt((n - n3) * (n - n3) + (n2 - n4) * (n2 - n4));
        return d;
    }

    private boolean testSoldier(Soldier soldier, List<Soldier> list, int[] nArray) {
        ListIterator<Soldier> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Soldier soldier2 = listIterator.next();
            if (Math.abs(soldier.x - soldier2.x) >= 20 || Math.abs(soldier.y - soldier2.y) >= 20) continue;
            return false;
        }
        int n = nArray.length / 3;
        for (int i = 0; i < n; ++i) {
            if (!(this.distance(soldier.x, soldier.y, nArray[3 * i], nArray[3 * i + 1]) < (double)(nArray[3 * i + 2] + 15))) continue;
            return false;
        }
        return true;
    }

    private Soldier generateSoldier(List<Soldier> list, int[] nArray, int n) {
        int n2;
        int n3;
        Soldier soldier;
        do {
            n3 = random.nextInt(371) + 7;
            n2 = random.nextInt(436) + 7;
            if (n != 2) continue;
            n3 += 385;
        } while (!this.testSoldier(soldier = new Soldier(n3, n2), list, nArray));
        return soldier;
    }

    private int[] generateSoldiers(int[] nArray) {
        Object object;
        ArrayList<Soldier> arrayList = new ArrayList<Soldier>();
        ListIterator<Player> listIterator = this.players.listIterator();
        while (listIterator.hasNext()) {
            object = listIterator.next();
            for (int i = 0; i < ((Player)object).getNumSoldiers(); ++i) {
                Soldier soldier = this.generateSoldier(arrayList, nArray, ((Player)object).getTeam());
                arrayList.add(soldier);
            }
        }
        object = new int[arrayList.size() * 2];
        ListIterator listIterator2 = arrayList.listIterator();
        int n = 0;
        while (listIterator2.hasNext()) {
            Soldier soldier = (Soldier)listIterator2.next();
            object[2 * n] = soldier.x;
            object[2 * n + 1] = soldier.y;
            ++n;
        }
        return object;
    }

    protected synchronized void sendStartGameMessage() {
        if (this.checkAllReady()) {
            this.startGame();
        }
        this.countingDown = false;
    }

    private void sendStartCountDown() {
        if (!this.countingDown) {
            this.countingDown = true;
            this.startDelayer = new StartDelayer(this);
            String string = "42";
            this.sendMessageAll(string);
        }
    }

    private void reorderPlayers() {
        Player player;
        Object object;
        ArrayList<Player> arrayList = new ArrayList<Player>();
        int n = 1;
        if (random.nextBoolean()) {
            n = 2;
        }
        while (this.players.size() > 0) {
            object = this.players.listIterator();
            boolean bl = false;
            while (object.hasNext()) {
                player = (Player)object.next();
                if (player.getTeam() != n) continue;
                object.remove();
                arrayList.add(player);
                n = n == 1 ? 2 : 1;
                bl = true;
            }
            if (bl) continue;
            if (n == 1) {
                n = 2;
                continue;
            }
            n = 1;
        }
        this.players = arrayList;
        object = "43";
        ListIterator<Player> listIterator = this.players.listIterator();
        while (listIterator.hasNext()) {
            player = listIterator.next();
            object = (String)object + "&" + player.getID();
        }
        this.sendMessageAll((String)object);
    }

    protected void startGame() {
        int n;
        this.acceptingConnections = false;
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.reorderPlayers();
        int[] nArray = this.generateCircles();
        int n2 = nArray.length / 3;
        int[] nArray2 = this.generateSoldiers(nArray);
        if (nArray2.length == 0) {
            return;
        }
        String string = "22&" + n2;
        for (n = 0; n < nArray.length; ++n) {
            string = string + "&" + nArray[n];
        }
        for (n = 0; n < nArray2.length; ++n) {
            string = string + "&" + nArray2[n];
        }
        n = Math.abs(random.nextInt() % this.players.size());
        while (this.players.get(n).getNumSoldiers() == 0) {
            n = Math.abs(random.nextInt() % this.players.size());
        }
        string = string + "&" + n;
        this.sendMessageAll(string);
        this.timeTurnStarted = System.currentTimeMillis();
        this.gameState = 2;
        this.setEveryoneNotReady();
    }

    private void checkNextTurn() {
        ListIterator<ClientConnection> listIterator = this.clients.listIterator();
        while (listIterator.hasNext()) {
            ClientConnection clientConnection = listIterator.next();
            if (clientConnection.getReadyNextTurn()) continue;
            return;
        }
        this.nextTurn();
    }

    private void nextTurn() {
        Object object;
        ListIterator<ClientConnection> listIterator = this.clients.listIterator();
        while (listIterator.hasNext()) {
            object = listIterator.next();
            ((ClientConnection)object).setReadyNextTurn(false);
        }
        object = "25";
        this.sendMessageAll((String)object);
        this.timeTurnStarted = System.currentTimeMillis();
    }

    protected void finishGame(ClientConnection clientConnection) {
        Object object;
        clientConnection.setFinished(true);
        ListIterator<ClientConnection> listIterator = this.clients.listIterator();
        while (listIterator.hasNext()) {
            object = listIterator.next();
            if (((ClientConnection)object).isFinished()) continue;
            return;
        }
        listIterator = this.clients.listIterator();
        while (listIterator.hasNext()) {
            object = listIterator.next();
            ((ClientConnection)object).setFinished(false);
            ((ClientConnection)object).setSkipLevel(false);
        }
        this.setEveryoneNotReady();
        object = "40";
        this.sendMessageAll((String)object);
        this.goPreGame();
    }

    protected void goPreGame() {
        this.gameState = 1;
        try {
            this.serverSocket = new ServerSocket(this.port);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        new Thread(this).start();
    }

    private void checkTimeUp() {
        if (System.currentTimeMillis() - this.timeTurnStarted > 60000L) {
            this.nextTurn();
        }
    }

    private void checkSkipLevel() {
        ClientConnection clientConnection;
        ListIterator<ClientConnection> listIterator = this.clients.listIterator();
        while (listIterator.hasNext()) {
            clientConnection = listIterator.next();
            if (clientConnection.getSkipLevel()) continue;
            return;
        }
        listIterator = this.clients.listIterator();
        while (listIterator.hasNext()) {
            clientConnection = listIterator.next();
            clientConnection.setSkipLevel(false);
        }
        this.startGame();
    }

    private void handleCommands(String string, ClientConnection clientConnection) throws UnsupportedEncodingException {
        if (string.startsWith("-") && string.compareToIgnoreCase("-skip") == 0 && this.gameState == 2) {
            clientConnection.setSkipLevel(true);
            this.checkSkipLevel();
        }
    }

    public synchronized void handleMessage(String string, ClientConnection clientConnection) {
        String[] stringArray = string.split("&");
        try {
            int n = Integer.parseInt(stringArray[0]);
            switch (n) {
                case 10: {
                    break;
                }
                case 16: {
                    if (this.players.size() >= 10) break;
                    Player player = new Player(stringArray[1]);
                    clientConnection.addPlayer(player);
                    this.players.add(player);
                    this.setEveryoneNotReady();
                    this.sendAddPlayerMessage(player, clientConnection);
                    break;
                }
                case 20: {
                    int n2 = Integer.parseInt(stringArray[1]);
                    int n3 = Integer.parseInt(stringArray[2]);
                    if (this.setTeam(n2, n3, clientConnection)) {
                        this.setEveryoneNotReady();
                        this.sendMessageAll(string);
                    }
                    break;
                }
                case 29: {
                    int n4 = Integer.parseInt(stringArray[1]);
                    if (this.removePlayer(n4, clientConnection)) {
                        this.setEveryoneNotReady();
                        this.sendMessageAll(string);
                    }
                    break;
                }
                case 17: {
                    int n5 = Integer.parseInt(stringArray[1]);
                    if (this.addSoldier(n5, clientConnection)) {
                        this.setEveryoneNotReady();
                        this.sendMessageAll(string);
                    }
                    break;
                }
                case 19: {
                    int n6 = Integer.parseInt(stringArray[1]);
                    if (this.removeSoldier(n6, clientConnection)) {
                        this.setEveryoneNotReady();
                        this.sendMessageAll(string);
                    }
                    break;
                }
                case 14: {
                    int n7 = Integer.parseInt(stringArray[1]);
                    if (this.checkPlayer(n7, clientConnection)) {
                        this.handleCommands(stringArray[2], clientConnection);
                        this.sendMessageAll(string);
                    }
                    break;
                }
                case 31: {
                    if (!clientConnection.isLeader()) break;
                    this.gameMode = (this.gameMode + 1) % 3;
                    this.setEveryoneNotReady();
                    this.sendModeMessage();
                    break;
                }
                case 21: {
                    boolean bl;
                    int n8 = Integer.parseInt(stringArray[1]);
                    boolean bl2 = bl = Integer.parseInt(stringArray[2]) != 0;
                    if (this.setReady(n8, clientConnection, bl)) {
                        this.sendMessageAll(string);
                    }
                    if (this.checkAllReady()) {
                        this.sendStartCountDown();
                    }
                    break;
                }
                case 27: {
                    if (this.gameState != 2) break;
                    clientConnection.setReadyNextTurn(true);
                    this.checkNextTurn();
                    break;
                }
                case 24: {
                    int n9 = Integer.parseInt(stringArray[1]);
                    if (this.checkPlayer(n9, clientConnection) && this.gameState == 2) {
                        this.sendMessageAll(string);
                    }
                    break;
                }
                case 44: {
                    int n10 = Integer.parseInt(stringArray[1]);
                    if (this.checkPlayer(n10, clientConnection) && this.gameState == 2) {
                        this.sendMessageAll(string);
                    }
                    break;
                }
                case 37: {
                    if (this.gameState != 2) break;
                    this.checkTimeUp();
                    break;
                }
                case 40: {
                    this.finishGame(clientConnection);
                    break;
                }
                case 28: {
                    int n11 = Integer.parseInt(stringArray[1]);
                    if (this.checkPlayer(n11, clientConnection) && this.gameState == 2) {
                        this.sendMessageAll(string);
                    }
                    break;
                }
                case 39: {
                    this.removeClient(clientConnection);
                    clientConnection.disconnect();
                }
            }
        }
        catch (Exception exception) {
            this.invalidMessage(string);
            exception.printStackTrace();
        }
    }

    private void invalidMessage(String string) {
        System.out.println("Invalid message received: " + string);
    }

    private class StartDelayer
    implements Runnable {
        GraphServer graphServer;
        Thread thisThread;

        public StartDelayer(GraphServer graphServer2) {
            this.graphServer = graphServer2;
            this.thisThread = new Thread(this);
            this.thisThread.start();
        }

        public void stop() {
            this.thisThread.interrupt();
            GraphServer.this.countingDown = false;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(5000L);
                this.graphServer.sendStartGameMessage();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    private class Soldier {
        public int x;
        public int y;

        public Soldier(int n, int n2) {
            this.x = n;
            this.y = n2;
        }
    }
}

