/*
 * Decompiled with CFR 0.152.
 */
package Graphwar;

import Graphwar.Function;
import Graphwar.Graphwar;
import Graphwar.Player;
import Graphwar.PolishNotationFunction;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;

public class ComputerPlayer
extends Player
implements Runnable {
    private int numGenerations;
    private int numFunctions;
    private EvolvableFunction[] bestFunction;
    private EvolvableFunction[][] functions;
    private boolean over9000;
    private boolean myTurn;
    private double bestAngle;
    private String function;
    private boolean processingFunction;
    private Graphwar graphwar;
    private static Random random = new Random();

    public ComputerPlayer(String string, int n, int n2, boolean bl, int n3, boolean bl2, int n4, Graphwar graphwar) {
        super(string, n, n2, bl, n3, bl2);
        int n5;
        this.graphwar = graphwar;
        this.numGenerations = n4;
        this.over9000 = n4 > 9000;
        this.numFunctions = 50;
        this.bestFunction = new EvolvableFunction[4];
        for (n5 = 0; n5 < 4; ++n5) {
            this.bestFunction[n5] = new EvolvableFunction();
            this.bestFunction[n5].function.makeRandomFunction(0);
            this.bestFunction[n5].angle = Math.PI * random.nextDouble() - 1.5707963267948966;
        }
        this.functions = new EvolvableFunction[4][this.numFunctions];
        for (n5 = 0; n5 < 4; ++n5) {
            for (int i = 0; i < this.numFunctions; ++i) {
                this.functions[n5][i] = new EvolvableFunction();
                this.functions[n5][i].function.makeRandomFunction(0);
                this.functions[n5][i].angle = Math.PI * random.nextDouble() - 1.5707963267948966;
            }
        }
        this.function = "0";
        this.bestAngle = 0.0;
        this.myTurn = false;
    }

    public double getAngle() {
        return this.bestAngle;
    }

    public void thinkFunction() {
        if (this.over9000) {
            this.myTurn = true;
        }
        if (!this.processingFunction) {
            this.processingFunction = true;
            new Thread(this).start();
        }
    }

    public void stopThinkFunction() {
        this.myTurn = false;
        this.processingFunction = false;
    }

    private double evaluateFunction(PolishNotationFunction polishNotationFunction, double d) {
        Function function = new Function(polishNotationFunction);
        Player[] playerArray = this.graphwar.getGameData().getPlayers().toArray(new Player[0]);
        int n = playerArray.length;
        boolean bl = this.team != 1;
        switch (this.graphwar.getGameData().getGameMode()) {
            case 0: {
                function.processFunctionRange(this.graphwar.getGameData().getObstacle(), playerArray, n, this.graphwar.getGameData().getCurrentTurnIndex(), bl);
                break;
            }
            case 1: {
                function.processRK4Range(this.graphwar.getGameData().getObstacle(), playerArray, n, this.graphwar.getGameData().getCurrentTurnIndex(), bl);
                break;
            }
            case 2: {
                function.processRK42Range(this.graphwar.getGameData().getObstacle(), playerArray, n, this.graphwar.getGameData().getCurrentTurnIndex(), d, bl);
            }
        }
        double d2 = 1000000.0;
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            block6: for (int j = 0; j < playerArray[i].getNumSoldiers(); ++j) {
                if (!playerArray[i].soldiers[j].isAlive()) continue;
                for (int k = 0; k < function.getNumPlayersHit(); ++k) {
                    if (function.getPlayerHit(k) != i || function.getSoldierHit(k) != j) continue;
                    if (playerArray[i].getTeam() != this.team) {
                        d3 += 2000000.0;
                        continue block6;
                    }
                    d3 -= 2000000.0;
                    continue block6;
                }
                if (playerArray[i].getTeam() == this.team) continue;
                double d4 = Double.MAX_VALUE;
                for (int k = 0; k < function.getNumSteps(); ++k) {
                    double d5;
                    double d6;
                    double d7 = -770.0 * function.getY(k) / 50.0 + 225.0 - (double)playerArray[i].getSoldiers()[j].getY();
                    if ((this.team != 2 ? (d6 = 770.0 * function.getX(k) / 50.0 + 385.0 - (double)playerArray[i].getSoldiers()[j].getX()) > 0.0 : (d6 = 770.0 - (770.0 * function.getX(k) / 50.0 + 385.0) - (double)playerArray[i].getSoldiers()[j].getX()) < 0.0) || !((d5 = Math.pow(d6, 2.0) + Math.pow(d7, 2.0)) < d4)) continue;
                    d4 = d5;
                }
                if (!(d4 < d2)) continue;
                d2 = d4;
            }
        }
        return d3 += 1000000.0 - d2;
    }

    private int getFunctionToReproduce(EvolvableFunction[] evolvableFunctionArray, double d) {
        double d2 = d * random.nextDouble();
        for (int i = 0; i < evolvableFunctionArray.length; ++i) {
            if (d > d2) {
                d -= evolvableFunctionArray[i].points;
                continue;
            }
            return i;
        }
        return 0;
    }

    private double getTotalPoints(EvolvableFunction[] evolvableFunctionArray) {
        double d = 0.0;
        for (int i = 0; i < evolvableFunctionArray.length; ++i) {
            d += evolvableFunctionArray[i].points;
        }
        return d;
    }

    @Override
    public void run() {
        int n = this.graphwar.getGameData().getGameMode();
        EvolvableFunction[] evolvableFunctionArray = this.functions[this.getCurrentTurnSoldierIndex()];
        double d = 0.0;
        block0: for (int i = 0; this.processingFunction && this.graphwar.getGameData().getGameState() == 2 && (i < this.numGenerations && this.graphwar.getGameData().getRemainingTime() > 5000L || this.over9000); ++i) {
            int n2;
            int n3;
            if (this.graphwar.getGameData().getCurrentTurnPlayer() == this) {
                evolvableFunctionArray = this.functions[this.currentTurnSoldier];
            } else {
                int n4 = this.getCurrentTurnSoldierIndex();
                if (n4 == -1) {
                    return;
                }
                evolvableFunctionArray = this.functions[n4];
            }
            EvolvableFunction[] evolvableFunctionArray2 = new EvolvableFunction[this.numFunctions];
            d = this.getTotalPoints(evolvableFunctionArray);
            for (n3 = 0; n3 < 5; ++n3) {
                evolvableFunctionArray2[n3] = evolvableFunctionArray[n3];
            }
            for (n3 = 5; n3 < 30; ++n3) {
                evolvableFunctionArray2[n3] = new EvolvableFunction();
                n2 = this.getFunctionToReproduce(evolvableFunctionArray, d);
                evolvableFunctionArray2[n3].function = new PolishNotationFunction(evolvableFunctionArray[n2].function, n);
                evolvableFunctionArray2[n3].angle = evolvableFunctionArray[n2].angle;
                if (n != 2 || !random.nextBoolean()) continue;
                if (random.nextBoolean()) {
                    evolvableFunctionArray[n3].angle = Math.PI * random.nextDouble() - 1.5707963267948966;
                    continue;
                }
                evolvableFunctionArray[n3].angle += evolvableFunctionArray[n3].angle * (random.nextDouble() - 0.5) / 5.0;
            }
            for (n3 = 30; n3 < this.numFunctions; ++n3) {
                evolvableFunctionArray2[n3] = new EvolvableFunction();
                n2 = this.getFunctionToReproduce(evolvableFunctionArray, d);
                int n5 = this.getFunctionToReproduce(evolvableFunctionArray, d);
                evolvableFunctionArray2[n3].function = new PolishNotationFunction(evolvableFunctionArray[n2].function, evolvableFunctionArray[n5].function, n);
                evolvableFunctionArray2[n3].angle = random.nextBoolean() ? evolvableFunctionArray[n2].angle : evolvableFunctionArray[n5].angle;
                if (n != 2 || !random.nextBoolean()) continue;
                if (random.nextBoolean()) {
                    evolvableFunctionArray[n3].angle = Math.PI * random.nextDouble() - 1.5707963267948966;
                    continue;
                }
                evolvableFunctionArray[n3].angle += evolvableFunctionArray[n3].angle * (random.nextDouble() - 0.5) / 5.0;
            }
            EvolvableFunction[] evolvableFunctionArray3 = this.functions[this.currentTurnSoldier];
            this.functions[this.currentTurnSoldier] = evolvableFunctionArray2;
            evolvableFunctionArray = evolvableFunctionArray2;
            for (n2 = 0; n2 < this.numFunctions; ++n2) {
                double d2;
                evolvableFunctionArray[n2].points = d2 = this.evaluateFunction(evolvableFunctionArray[n2].function, evolvableFunctionArray[n2].angle);
                if (this.graphwar.getGameData().getRemainingTime() >= 3000L || this.over9000) continue;
                evolvableFunctionArray = evolvableFunctionArray3;
                this.functions[this.currentTurnSoldier] = evolvableFunctionArray3;
                break block0;
            }
            Arrays.sort(evolvableFunctionArray, evolvableFunctionArray[0]);
            if (!this.over9000 || !this.myTurn || this.graphwar.getGameData().getRemainingTime() >= 5000L) continue;
            this.bestFunction[this.currentTurnSoldier] = evolvableFunctionArray[0];
            this.sendFunction();
            this.myTurn = false;
        }
        if (this.processingFunction && !this.over9000) {
            this.bestFunction[this.currentTurnSoldier] = evolvableFunctionArray[0];
            this.sendFunction();
        }
        this.processingFunction = false;
    }

    private void sendFunction() {
        this.function = this.bestFunction[this.currentTurnSoldier].function.simplifyFunction().getStringFunction();
        this.bestAngle = this.bestFunction[this.currentTurnSoldier].angle;
        this.graphwar.getGameData().setAngle(this.bestAngle);
        this.graphwar.getGameData().sendFunction(this.function);
    }

    private class EvolvableFunction
    implements Comparator<EvolvableFunction> {
        public PolishNotationFunction function = new PolishNotationFunction();
        public double angle = 0.0;
        public double points = 0.0;

        EvolvableFunction() {
        }

        @Override
        public int compare(EvolvableFunction evolvableFunction, EvolvableFunction evolvableFunction2) {
            if (evolvableFunction.points < evolvableFunction2.points) {
                return 1;
            }
            if (evolvableFunction.points > evolvableFunction2.points) {
                return -1;
            }
            return 0;
        }
    }
}

