/*
 * Decompiled with CFR 0.152.
 */
package Graphwar;

import Graphwar.MalformedFunction;
import Graphwar.Obstacle;
import Graphwar.Player;
import Graphwar.PolishNotationFunction;
import Graphwar.Soldier;

public class Function {
    private String strFunc;
    private PolishNotationFunction polishFunc;
    private double offSet;
    private double fireAngle;
    private double[] valuesX;
    private double[] valuesY;
    private double[] valuesDY;
    private int numSteps;
    private int[] playersHit;
    private int[] soldiersHit;
    private int[] soldierHitPosition;
    private int numPlayersHit;
    private double lastX;
    private double lastY;

    Function(String string) throws MalformedFunction {
        this.strFunc = string;
        this.polishFunc = new PolishNotationFunction(this.strFunc);
        this.offSet = 0.0;
        this.fireAngle = 0.0;
        this.valuesX = null;
        this.valuesY = null;
        this.valuesDY = null;
        this.numSteps = 0;
        this.playersHit = null;
        this.soldiersHit = null;
        this.numPlayersHit = 0;
        this.lastX = 0.0;
        this.lastY = 0.0;
    }

    Function(PolishNotationFunction polishNotationFunction) {
        this.strFunc = "";
        this.polishFunc = polishNotationFunction;
        this.offSet = 0.0;
        this.fireAngle = 0.0;
        this.valuesX = null;
        this.valuesY = null;
        this.valuesDY = null;
        this.numSteps = 0;
        this.playersHit = null;
        this.soldiersHit = null;
        this.soldierHitPosition = null;
        this.numPlayersHit = 0;
        this.lastX = 0.0;
        this.lastY = 0.0;
    }

    public int getNumPlayersHit() {
        return this.numPlayersHit;
    }

    public int getPlayerHit(int n) {
        return this.playersHit[n];
    }

    public int getSoldierHit(int n) {
        return this.soldiersHit[n];
    }

    public int getSoldierHitPosition(int n) {
        return this.soldierHitPosition[n];
    }

    public double getFireAngle() {
        return this.fireAngle;
    }

    public double getX(int n) {
        return this.valuesX[n];
    }

    public double getY(int n) {
        return this.valuesY[n];
    }

    public int getNumSteps() {
        return this.numSteps;
    }

    public String getStringFunc() {
        return this.strFunc;
    }

    private double getStartAngle(double d, double d2) {
        double d3 = 0.0;
        double d4 = (this.polishFunc.evaluateFunction(d + 0.01, 0.0, 0.0) - this.polishFunc.evaluateFunction(d, 0.0, 0.0)) / 0.01;
        d3 = Math.atan(d4);
        double d5 = 10000.0;
        for (int i = 0; d5 > Math.PI / 360 && i < 100; ++i) {
            double d6 = d + d2 * Math.cos(d3);
            d4 = (this.polishFunc.evaluateFunction(d6 + 0.01, 0.0, 0.0) - this.polishFunc.evaluateFunction(d6, 0.0, 0.0)) / 0.01;
            double d7 = Math.atan(d4);
            d5 = Math.abs(d7 - d3);
            d3 = d7;
        }
        return d3;
    }

    private boolean playerAlreadyHit(int n, int n2) {
        for (int i = 0; i < this.numPlayersHit; ++i) {
            if (this.playersHit[i] != n || this.soldiersHit[i] != n2) continue;
            return true;
        }
        return false;
    }

    public void processFunctionRange(Obstacle obstacle, Player[] playerArray, int n, int n2, boolean bl) {
        this.playersHit = new int[n * 4];
        this.soldiersHit = new int[n * 4];
        this.soldierHitPosition = new int[n * 4];
        this.numPlayersHit = 0;
        this.valuesX = new double[20000];
        this.valuesY = new double[20000];
        Soldier soldier = playerArray[n2].getCurrentTurnSoldier();
        this.valuesX[0] = soldier.getX();
        this.valuesY[0] = soldier.getY();
        if (bl) {
            this.valuesX[0] = 770.0 - this.valuesX[0];
        }
        this.valuesX[0] = 50.0 * (this.valuesX[0] - 385.0) / 770.0;
        this.valuesY[0] = 50.0 * (-this.valuesY[0] + 225.0) / 770.0;
        double d = 0.45454545454545453;
        this.fireAngle = this.getStartAngle(this.valuesX[0], d);
        if (!Double.isNaN(this.fireAngle) && !Double.isInfinite(this.fireAngle)) {
            this.valuesX[0] = this.valuesX[0] + d * Math.cos(this.fireAngle);
            this.valuesY[0] = this.valuesY[0] + d * Math.sin(this.fireAngle);
        }
        this.offSet = -this.polishFunc.evaluateFunction(this.valuesX[0], 0.0, 0.0) + this.valuesY[0];
        double d2 = 0.01;
        double d3 = 0.01;
        this.numSteps = 20000;
        for (int i = 1; i < 20000; ++i) {
            d3 = d2;
            this.valuesX[i] = this.valuesX[i - 1] + d3;
            this.valuesY[i] = this.polishFunc.evaluateFunction(this.valuesX[i], 0.0, 0.0) + this.offSet;
            boolean bl2 = false;
            int n3 = 0;
            while (Math.pow(this.valuesX[i] - this.valuesX[i - 1], 2.0) + Math.pow(this.valuesY[i] - this.valuesY[i - 1], 2.0) > 0.001) {
                if (!(this.valuesX[i] - this.valuesX[i - 1] > 1.0E-5)) {
                    bl2 = true;
                    break;
                }
                this.valuesX[i] = this.valuesX[i - 1] + (d3 /= 2.0);
                this.valuesY[i] = this.polishFunc.evaluateFunction(this.valuesX[i], 0.0, 0.0) + this.offSet;
                ++n3;
            }
            if (bl2) {
                this.numSteps = i;
                break;
            }
            double d4 = 770.0 * this.valuesX[i] / 50.0 + 385.0;
            double d5 = -770.0 * this.valuesY[i] / 50.0 + 225.0;
            if (bl) {
                d4 = 770.0 - d4;
            }
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < playerArray[j].getNumSoldiers(); ++k) {
                    if (j == n2 && k == playerArray[j].getCurrentTurnSoldierIndex() || !playerArray[j].getSoldiers()[k].isAlive()) continue;
                    double d6 = (double)playerArray[j].getSoldiers()[k].getX() - d4;
                    double d7 = (double)playerArray[j].getSoldiers()[k].getY() - d5;
                    double d8 = Math.pow(d6, 2.0) + Math.pow(d7, 2.0);
                    if (!(d8 < 49.0) || this.playerAlreadyHit(j, k)) continue;
                    this.playersHit[this.numPlayersHit] = j;
                    this.soldiersHit[this.numPlayersHit] = k;
                    this.soldierHitPosition[this.numPlayersHit] = i;
                    ++this.numPlayersHit;
                }
            }
            if (obstacle.collidePoint((int)d4, (int)d5)) {
                this.numSteps = i;
                break;
            }
            if (!Double.isNaN(d5) && !Double.isInfinite(d5)) continue;
            this.numSteps = i;
            break;
        }
        this.lastX = 770.0 * this.valuesX[this.numSteps - 1] / 50.0 + 385.0;
        this.lastY = -770.0 * this.valuesY[this.numSteps - 1] / 50.0 + 225.0;
    }

    private double getRK4StartAngle(double d, double d2, double d3) {
        double d4 = 0.0;
        double d5 = 10000.0;
        for (int i = 0; d5 > Math.PI / 360 && i < 100; ++i) {
            double d6 = d + d3 * Math.cos(d4);
            double d7 = d2 + d3 * Math.sin(d4);
            double d8 = 0.01;
            double d9 = this.polishFunc.evaluateFunction(d6, d7, 0.0);
            double d10 = this.polishFunc.evaluateFunction(d6 + 0.5 * d8, d7 + 0.5 * d8 * d9, 0.0);
            double d11 = this.polishFunc.evaluateFunction(d6 + 0.5 * d8, d7 + 0.5 * d8 * d10, 0.0);
            double d12 = this.polishFunc.evaluateFunction(d6 + d8, d7 + d8 * d11, 0.0);
            double d13 = d7 + d8 / 6.0 * (d9 + 2.0 * d10 + 2.0 * d11 + d12);
            double d14 = d6 + d8;
            double d15 = (d13 - d7) / (d14 - d6);
            double d16 = Math.atan(d15);
            d5 = Math.abs(d16 - d4);
            d4 = d16;
        }
        return d4;
    }

    public void processRK4Range(Obstacle obstacle, Player[] playerArray, int n, int n2, boolean bl) {
        this.playersHit = new int[n * 4];
        this.soldiersHit = new int[n * 4];
        this.soldierHitPosition = new int[n * 4];
        this.numPlayersHit = 0;
        this.valuesX = new double[20000];
        this.valuesY = new double[20000];
        double d = 0.01;
        Soldier soldier = playerArray[n2].getCurrentTurnSoldier();
        this.valuesX[0] = soldier.getX();
        this.valuesY[0] = soldier.getY();
        if (bl) {
            this.valuesX[0] = 770.0 - this.valuesX[0];
        }
        this.valuesX[0] = 50.0 * (this.valuesX[0] - 385.0) / 770.0;
        this.valuesY[0] = 50.0 * (-this.valuesY[0] + 225.0) / 770.0;
        double d2 = 0.45454545454545453;
        this.fireAngle = this.getRK4StartAngle(this.valuesX[0], this.valuesY[0], d2);
        this.valuesX[0] = this.valuesX[0] + d2 * Math.cos(this.fireAngle);
        this.valuesY[0] = this.valuesY[0] + d2 * Math.sin(this.fireAngle);
        this.numSteps = 20000;
        for (int i = 1; i < 20000; ++i) {
            double d3 = d;
            double d4 = this.polishFunc.evaluateFunction(this.valuesX[i - 1], this.valuesY[i - 1], 0.0);
            double d5 = this.polishFunc.evaluateFunction(this.valuesX[i - 1] + 0.5 * d3, this.valuesY[i - 1] + 0.5 * d3 * d4, 0.0);
            double d6 = this.polishFunc.evaluateFunction(this.valuesX[i - 1] + 0.5 * d3, this.valuesY[i - 1] + 0.5 * d3 * d5, 0.0);
            double d7 = this.polishFunc.evaluateFunction(this.valuesX[i - 1] + d3, this.valuesY[i - 1] + d3 * d6, 0.0);
            this.valuesY[i] = this.valuesY[i - 1] + d3 / 6.0 * (d4 + 2.0 * d5 + 2.0 * d6 + d7);
            this.valuesX[i] = this.valuesX[i - 1] + d3;
            boolean bl2 = false;
            int n3 = 0;
            while (Math.pow(this.valuesX[i] - this.valuesX[i - 1], 2.0) + Math.pow(this.valuesY[i] - this.valuesY[i - 1], 2.0) > 0.001 && this.valuesX[i] - this.valuesX[i - 1] > 1.0E-5) {
                if (!(this.valuesX[i] - this.valuesX[i - 1] > 1.0E-5)) {
                    bl2 = true;
                    break;
                }
                d4 = this.polishFunc.evaluateFunction(this.valuesX[i - 1], this.valuesY[i - 1], 0.0);
                d5 = this.polishFunc.evaluateFunction(this.valuesX[i - 1] + 0.5 * (d3 /= 2.0), this.valuesY[i - 1] + 0.5 * d3 * d4, 0.0);
                d6 = this.polishFunc.evaluateFunction(this.valuesX[i - 1] + 0.5 * d3, this.valuesY[i - 1] + 0.5 * d3 * d5, 0.0);
                d7 = this.polishFunc.evaluateFunction(this.valuesX[i - 1] + d3, this.valuesY[i - 1] + d3 * d6, 0.0);
                this.valuesY[i] = this.valuesY[i - 1] + d3 / 6.0 * (d4 + 2.0 * d5 + 2.0 * d6 + d7);
                this.valuesX[i] = this.valuesX[i - 1] + d3;
                ++n3;
            }
            if (bl2) {
                this.numSteps = i;
                break;
            }
            double d8 = 770.0 * this.valuesX[i] / 50.0 + 385.0;
            double d9 = -770.0 * this.valuesY[i] / 50.0 + 225.0;
            if (bl) {
                d8 = 770.0 - d8;
            }
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < playerArray[j].getNumSoldiers(); ++k) {
                    if (j == n2 && k == playerArray[j].getCurrentTurnSoldierIndex() || !playerArray[j].getSoldiers()[k].isAlive()) continue;
                    double d10 = (double)playerArray[j].getSoldiers()[k].getX() - d8;
                    double d11 = (double)playerArray[j].getSoldiers()[k].getY() - d9;
                    double d12 = Math.pow(d10, 2.0) + Math.pow(d11, 2.0);
                    if (!(d12 < 49.0) || this.playerAlreadyHit(j, k)) continue;
                    this.playersHit[this.numPlayersHit] = j;
                    this.soldiersHit[this.numPlayersHit] = k;
                    this.soldierHitPosition[this.numPlayersHit] = i;
                    ++this.numPlayersHit;
                }
            }
            if (obstacle.collidePoint((int)d8, (int)d9)) {
                this.numSteps = i;
                break;
            }
            if (!Double.isNaN(d9) && !Double.isInfinite(d9)) continue;
            this.numSteps = i;
            break;
        }
        this.lastX = 770.0 * this.valuesX[this.numSteps - 1] / 50.0 + 385.0;
        this.lastY = -770.0 * this.valuesY[this.numSteps - 1] / 50.0 + 225.0;
    }

    public void processRK42Range(Obstacle obstacle, Player[] playerArray, int n, int n2, double d, boolean bl) {
        this.playersHit = new int[n * 4];
        this.soldiersHit = new int[n * 4];
        this.soldierHitPosition = new int[n * 4];
        this.numPlayersHit = 0;
        this.valuesX = new double[20000];
        this.valuesY = new double[20000];
        this.valuesDY = new double[20000];
        double d2 = 0.01;
        Soldier soldier = playerArray[n2].getCurrentTurnSoldier();
        this.valuesX[0] = soldier.getX();
        if (bl) {
            this.valuesX[0] = 770.0 - this.valuesX[0];
        }
        this.valuesX[0] = this.valuesX[0] + 7.0 * Math.cos(d);
        this.valuesY[0] = soldier.getY();
        this.valuesY[0] = this.valuesY[0] - 7.0 * Math.sin(d);
        this.valuesX[0] = 50.0 * (this.valuesX[0] - 385.0) / 770.0;
        this.valuesY[0] = 50.0 * (-this.valuesY[0] + 225.0) / 770.0;
        this.valuesDY[0] = Math.tan(d);
        this.fireAngle = d;
        this.numSteps = 20000;
        for (int i = 1; i < 20000; ++i) {
            double d3;
            double d4 = d2;
            double d5 = this.valuesX[i - 1];
            double d6 = this.valuesY[i - 1];
            double d7 = d3 = this.valuesDY[i - 1];
            double d8 = this.polishFunc.evaluateFunction(d5, d6, d3);
            d5 = this.valuesX[i - 1] + d4 / 2.0;
            d6 = this.valuesY[i - 1] + d4 / 2.0 * d7;
            double d9 = d3 = this.valuesDY[i - 1] + d4 / 2.0 * d8;
            double d10 = this.polishFunc.evaluateFunction(d5, d6, d3);
            d6 = this.valuesY[i - 1] + d4 / 2.0 * d9;
            double d11 = d3 = this.valuesDY[i - 1] + d4 / 2.0 * d10;
            double d12 = this.polishFunc.evaluateFunction(d5, d6, d3);
            d5 = this.valuesX[i - 1] + d4;
            d6 = this.valuesY[i - 1] + d4 * d11;
            double d13 = d3 = this.valuesDY[i - 1] + d4 * d12;
            double d14 = this.polishFunc.evaluateFunction(d5, d6, d3);
            this.valuesX[i] = this.valuesX[i - 1] + d4;
            this.valuesY[i] = this.valuesY[i - 1] + d4 / 6.0 * (d7 + 2.0 * d9 + 2.0 * d11 + d13);
            this.valuesDY[i] = this.valuesDY[i - 1] + d4 / 6.0 * (d8 + 2.0 * d10 + 2.0 * d12 + d14);
            boolean bl2 = false;
            int n3 = 0;
            while (Math.pow(this.valuesX[i] - this.valuesX[i - 1], 2.0) + Math.pow(this.valuesY[i] - this.valuesY[i - 1], 2.0) > 0.001 && this.valuesX[i] - this.valuesX[i - 1] > 1.0E-5) {
                if (!(this.valuesX[i] - this.valuesX[i - 1] > 1.0E-5)) {
                    bl2 = true;
                    break;
                }
                d5 = this.valuesX[i - 1];
                d6 = this.valuesY[i - 1];
                d7 = d3 = this.valuesDY[i - 1];
                d8 = this.polishFunc.evaluateFunction(d5, d6, d3);
                d5 = this.valuesX[i - 1] + (d4 /= 2.0) / 2.0;
                d6 = this.valuesY[i - 1] + d4 / 2.0 * d7;
                d9 = d3 = this.valuesDY[i - 1] + d4 / 2.0 * d8;
                d10 = this.polishFunc.evaluateFunction(d5, d6, d3);
                d6 = this.valuesY[i - 1] + d4 / 2.0 * d9;
                d11 = d3 = this.valuesDY[i - 1] + d4 / 2.0 * d10;
                d12 = this.polishFunc.evaluateFunction(d5, d6, d3);
                d5 = this.valuesX[i - 1] + d4;
                d6 = this.valuesY[i - 1] + d4 * d11;
                d13 = d3 = this.valuesDY[i - 1] + d4 * d12;
                d14 = this.polishFunc.evaluateFunction(d5, d6, d3);
                this.valuesX[i] = this.valuesX[i - 1] + d4;
                this.valuesY[i] = this.valuesY[i - 1] + d4 / 6.0 * (d7 + 2.0 * d9 + 2.0 * d11 + d13);
                this.valuesDY[i] = this.valuesDY[i - 1] + d4 / 6.0 * (d8 + 2.0 * d10 + 2.0 * d12 + d14);
                ++n3;
            }
            if (bl2) {
                this.numSteps = i;
                break;
            }
            double d15 = 770.0 * this.valuesX[i] / 50.0 + 385.0;
            double d16 = -770.0 * this.valuesY[i] / 50.0 + 225.0;
            if (bl) {
                d15 = 770.0 - d15;
            }
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < playerArray[j].getNumSoldiers(); ++k) {
                    if (j == n2 && k == playerArray[j].getCurrentTurnSoldierIndex() || !playerArray[j].getSoldiers()[k].isAlive()) continue;
                    double d17 = (double)playerArray[j].getSoldiers()[k].getX() - d15;
                    double d18 = (double)playerArray[j].getSoldiers()[k].getY() - d16;
                    double d19 = Math.pow(d17, 2.0) + Math.pow(d18, 2.0);
                    if (!(d19 < 49.0) || this.playerAlreadyHit(j, k)) continue;
                    this.playersHit[this.numPlayersHit] = j;
                    this.soldiersHit[this.numPlayersHit] = k;
                    this.soldierHitPosition[this.numPlayersHit] = i;
                    ++this.numPlayersHit;
                }
            }
            if (obstacle.collidePoint((int)d15, (int)d16)) {
                this.numSteps = i;
                break;
            }
            if (!Double.isNaN(d16) && !Double.isInfinite(d16)) continue;
            this.numSteps = i;
            break;
        }
        this.lastX = 770.0 * this.valuesX[this.numSteps - 1] / 50.0 + 385.0;
        this.lastY = -770.0 * this.valuesY[this.numSteps - 1] / 50.0 + 225.0;
    }

    public double getLastX() {
        return this.lastX;
    }

    public double getLastY() {
        return this.lastY;
    }
}

