/*
 * Decompiled with CFR 0.152.
 */
package Graphwar;

import Graphwar.ComputerPlayer;
import Graphwar.Function;
import Graphwar.GameScreen;
import Graphwar.GlobalScreen;
import Graphwar.Graphwar;
import Graphwar.MalformedFunction;
import Graphwar.Obstacle;
import Graphwar.Player;
import Graphwar.PreGameScreen;
import Graphwar.ServerConnection;
import Graphwar.Soldier;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Queue;

public class GameData
implements Runnable {
    private Graphwar graphwar;
    private ServerConnection serverConnection;
    private List<Player> players;
    private Queue<Integer> nextPCs;
    private Obstacle obstacle;
    private int gameMode;
    private int gameState;
    private boolean leader;
    private int currentTurn;
    private Player lastLocalHumanPlayer;
    private long timeTurnStarted;
    private boolean turnTimeUp;
    private boolean nextTurnSent;
    private Function function;
    private boolean drawingFunction;
    private long timeStartedDrawingFunction;
    private boolean exploding;
    private long timeStartedExploding;
    private ArrayList<Soldier> soldiersHit;
    private boolean angleUp;
    private boolean angleDown;
    private long timeStartedAngle;
    private boolean countingDown;
    private Countdowner countdowner;
    private boolean sayFunc;

    public GameData(Graphwar graphwar) {
        this.graphwar = graphwar;
        this.serverConnection = null;
        this.players = new ArrayList<Player>();
        this.nextPCs = new LinkedList<Integer>();
        this.obstacle = null;
        this.gameMode = 0;
        this.gameState = 0;
        this.function = null;
        this.drawingFunction = false;
        this.exploding = false;
        this.soldiersHit = new ArrayList();
        this.leader = false;
        this.lastLocalHumanPlayer = null;
        this.currentTurn = -1;
        this.turnTimeUp = false;
        this.nextTurnSent = false;
        this.countingDown = false;
        this.countdowner = null;
        this.sayFunc = true;
    }

    public void connect(String string, int n) throws IOException {
        this.serverConnection = new ServerConnection(this, string, n);
        new Thread(this.serverConnection).start();
        this.gameState = 1;
        this.drawingFunction = false;
        this.exploding = false;
        this.players = new ArrayList<Player>();
        this.lastLocalHumanPlayer = null;
        this.currentTurn = -1;
        this.turnTimeUp = false;
        this.nextTurnSent = false;
        new Thread(this).start();
        ((GlobalScreen)this.graphwar.getUI().getScreen(2)).refreshGameButton();
    }

    public List<Player> getPlayers() {
        return this.players;
    }

    public Player getPlayer(int n) {
        ListIterator<Player> listIterator = this.players.listIterator();
        while (listIterator.hasNext()) {
            Player player = listIterator.next();
            if (player.getID() != n) continue;
            return player;
        }
        return null;
    }

    public Player getFirstLocalPlayer() {
        ListIterator<Player> listIterator = this.players.listIterator();
        while (listIterator.hasNext()) {
            Player player = listIterator.next();
            if (!player.isLocalPlayer()) continue;
            return player;
        }
        return null;
    }

    public boolean isTerrainReversed() {
        if (this.lastLocalHumanPlayer == null) {
            return this.getFirstLocalPlayer() != null && this.getFirstLocalPlayer().getTeam() == 2;
        }
        return this.lastLocalHumanPlayer.getTeam() == 2;
    }

    public boolean isLeader() {
        return this.leader;
    }

    public boolean isFunctionReversed() {
        return this.getCurrentTurnPlayer().getTeam() == 2;
    }

    public Obstacle getObstacle() {
        return this.obstacle;
    }

    public Player getCurrentTurnPlayer() {
        return this.players.get(this.currentTurn);
    }

    public int getCurrentTurnIndex() {
        return this.currentTurn;
    }

    public synchronized long getRemainingTime() {
        long l = 60000L - (System.currentTimeMillis() - this.timeTurnStarted);
        if (this.drawingFunction || this.exploding) {
            l = 60000L - (this.timeStartedDrawingFunction - this.timeTurnStarted);
        }
        if (l < 0L) {
            l = 0L;
            if (!this.turnTimeUp) {
                this.turnTimeUp = true;
                if (this.gameState == 2) {
                    String string = "37";
                    this.serverConnection.sendMessage(string);
                }
            }
        }
        return l;
    }

    public void sendChatMessage(String string) {
        try {
            Player player = this.getFirstLocalPlayer();
            int n = -1;
            if (player != null) {
                n = player.getID();
            }
            String string2 = "14&" + n + "&" + URLEncoder.encode(string, "UTF-8");
            this.serverConnection.sendMessage(string2);
            this.handleCommands(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    public void sendChatMessage(Player player, String string) {
        try {
            if (player.isLocalPlayer()) {
                int n = player.getID();
                String string2 = "14&" + n + "&" + URLEncoder.encode(string, "UTF-8");
                this.serverConnection.sendMessage(string2);
                this.handleCommands(string);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    public void sendFunctionPreview(String string) {
        Player player = this.getCurrentTurnPlayer();
        if (player.isLocalPlayer() && !this.drawingFunction) {
            try {
                String string2 = "44&" + player.getID() + "&" + URLEncoder.encode(string, "UTF-8");
                this.serverConnection.sendMessage(string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
    }

    public void sendFunction(String string) {
        Player player = this.getCurrentTurnPlayer();
        if (player.isLocalPlayer() && !this.drawingFunction) {
            Object object;
            try {
                object = new Function(string);
            }
            catch (MalformedFunction malformedFunction) {
                return;
            }
            try {
                object = "24&" + player.getID() + "&" + URLEncoder.encode(string, "UTF-8");
                this.serverConnection.sendMessage((String)object);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
    }

    public void nextMode() {
        String string = "31";
        this.serverConnection.sendMessage(string);
    }

    public int getGameMode() {
        return this.gameMode;
    }

    public int getGameState() {
        return this.gameState;
    }

    public void addPlayer(String string) {
        if (this.players.size() < 10) {
            try {
                String string2 = "16&" + URLEncoder.encode(string, "UTF-8");
                this.serverConnection.sendMessage(string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
    }

    public void addPC(String string, int n) {
        if (this.players.size() < 10) {
            this.nextPCs.add(new Integer(n));
            this.addPlayer(string);
        }
    }

    public void removePlayer(Player player) {
        String string = "29&" + player.getID();
        this.serverConnection.sendMessage(string);
    }

    public void addSoldier(Player player) {
        String string = "17&" + player.getID();
        this.serverConnection.sendMessage(string);
    }

    public void removeSoldier(Player player) {
        String string = "19&" + player.getID();
        this.serverConnection.sendMessage(string);
    }

    public void switchSide(Player player) {
        int n = 1;
        if (player.getTeam() == 1) {
            n = 2;
        }
        String string = "20&" + n + "&" + player.getID();
        this.serverConnection.sendMessage(string);
    }

    public boolean isAngleUp() {
        return this.angleUp;
    }

    public boolean isAngleDown() {
        return this.angleDown;
    }

    public void angleUp() {
        if (!this.angleUp && this.getCurrentTurnPlayer().isLocalPlayer() && !(this.getCurrentTurnPlayer() instanceof ComputerPlayer)) {
            this.timeStartedAngle = System.currentTimeMillis();
            this.angleUp = true;
            ((GameScreen)this.graphwar.getUI().getScreen(3)).repaintAngle();
        }
    }

    public void angleDown() {
        if (!this.angleDown && this.getCurrentTurnPlayer().isLocalPlayer() && !(this.getCurrentTurnPlayer() instanceof ComputerPlayer)) {
            this.timeStartedAngle = System.currentTimeMillis();
            this.angleDown = true;
            ((GameScreen)this.graphwar.getUI().getScreen(3)).repaintAngle();
        }
    }

    public void stopAngle() {
        if (this.getCurrentTurnPlayer().isLocalPlayer() && !(this.getCurrentTurnPlayer() instanceof ComputerPlayer)) {
            Player player = this.players.get(this.currentTurn);
            double d = this.getAngle();
            player.getCurrentTurnSoldier().setAngle(d);
            this.angleUp = false;
            this.angleDown = false;
            ((GameScreen)this.graphwar.getUI().getScreen(3)).repaintAngle();
            String string = "28&" + player.getID() + "&" + player.getCurrentTurnSoldierIndex() + "&" + d;
            this.serverConnection.sendMessage(string);
        }
    }

    public void setAngle(double d) {
        if (this.getCurrentTurnPlayer().isLocalPlayer()) {
            Player player = this.players.get(this.currentTurn);
            player.getCurrentTurnSoldier().setAngle(d);
            ((GameScreen)this.graphwar.getUI().getScreen(3)).repaintAngle();
            String string = "28&" + player.getID() + "&" + player.getCurrentTurnSoldierIndex() + "&" + d;
            this.serverConnection.sendMessage(string);
        }
    }

    public double getAngle() {
        long l = System.currentTimeMillis() - this.timeStartedAngle;
        double d = 3.0E-6;
        if (this.angleDown) {
            d = -d;
        }
        double d2 = d * (double)l * (double)l;
        double d3 = this.players.get(this.currentTurn).getCurrentTurnSoldier().getAngle() + d2;
        if (d3 > 1.5707963267948966) {
            d3 = 1.5707963267948966;
        }
        if (d3 < -1.5707963267948966) {
            d3 = -1.5707963267948966;
        }
        return d3;
    }

    public void setReady(Player player, boolean bl) {
        int n = 0;
        if (bl) {
            n = 1;
        }
        String string = "21&" + player.getID() + "&" + n;
        this.serverConnection.sendMessage(string);
    }

    private boolean checkGameFinished() {
        boolean bl = false;
        boolean bl2 = false;
        ListIterator<Player> listIterator = this.players.listIterator();
        while (listIterator.hasNext()) {
            Player player = listIterator.next();
            for (int i = 0; i < player.getNumSoldiers(); ++i) {
                if (!player.getSoldiers()[i].isAlive()) continue;
                if (player.getTeam() == 1) {
                    bl = true;
                    continue;
                }
                bl2 = true;
            }
        }
        return !bl || !bl2;
    }

    private void nextTurn() {
        if (this.checkGameFinished()) {
            String string = "40";
            this.serverConnection.sendMessage(string);
        } else {
            String string = "27";
            this.serverConnection.sendMessage(string);
        }
    }

    private void addSoldierMessage(String[] stringArray) throws Exception {
        int n = Integer.parseInt(stringArray[1]);
        Player player = this.getPlayer(n);
        player.setSoldiers(player.getNumSoldiers() + 1);
        ((PreGameScreen)this.graphwar.getUI().getScreen(1)).updatePlayer(player);
    }

    private void removeSoldierMessage(String[] stringArray) throws Exception {
        int n = Integer.parseInt(stringArray[1]);
        Player player = this.getPlayer(n);
        player.setSoldiers(player.getNumSoldiers() - 1);
        ((PreGameScreen)this.graphwar.getUI().getScreen(1)).updatePlayer(player);
    }

    private void removePlayerMessage(String[] stringArray) throws Exception {
        int n = Integer.parseInt(stringArray[1]);
        Player player = this.getPlayer(n);
        ((PreGameScreen)this.graphwar.getUI().getScreen(1)).removePlayer(player);
        ((PreGameScreen)this.graphwar.getUI().getScreen(1)).addChat(null, player.getName() + " has left the game.");
        if (this.gameState == 2) {
            if (this.players.get(this.currentTurn).getID() == player.getID() && !this.drawingFunction) {
                this.nextTurn();
            }
            for (int i = 0; i < player.getNumSoldiers(); ++i) {
                if (!player.getSoldiers()[i].isAlive()) continue;
                player.getSoldiers()[i].setAlive(false);
                player.getSoldiers()[i].setExploding(true);
            }
            player.markDisconnected();
            ((GameScreen)this.graphwar.getUI().getScreen(3)).addChat(null, player.getName() + " has left the game.");
        } else {
            this.players.remove(player);
            this.graphwar.getGlobalClient().sendRoomStatus();
            if (!this.checkHaveLocals()) {
                this.disconnectKick();
            }
        }
    }

    private boolean checkHaveLocals() {
        ListIterator<Player> listIterator = this.players.listIterator();
        while (listIterator.hasNext()) {
            Player player = listIterator.next();
            if (!player.isLocalPlayer()) continue;
            return true;
        }
        return false;
    }

    private void setSideMessage(String[] stringArray) throws Exception {
        int n = Integer.parseInt(stringArray[1]);
        int n2 = Integer.parseInt(stringArray[2]);
        Player player = this.getPlayer(n2);
        player.setTeam(n);
        ((PreGameScreen)this.graphwar.getUI().getScreen(1)).updatePlayer(player);
    }

    private void addPlayerMessage(String[] stringArray) throws Exception {
        Player player;
        boolean bl;
        int n = Integer.parseInt(stringArray[1]);
        String string = URLDecoder.decode(stringArray[2], "UTF-8");
        int n2 = Integer.parseInt(stringArray[3]);
        boolean bl2 = Integer.parseInt(stringArray[4]) != 0;
        int n3 = Integer.parseInt(stringArray[5]);
        boolean bl3 = bl = Integer.parseInt(stringArray[6]) != 0;
        if (bl2 && !this.nextPCs.isEmpty()) {
            int n4 = this.nextPCs.poll();
            player = new ComputerPlayer(string, n, n2, bl2, n3, bl, n4, this.graphwar);
        } else {
            player = new Player(string, n, n2, bl2, n3, bl);
        }
        this.players.add(player);
        ((PreGameScreen)this.graphwar.getUI().getScreen(1)).addPlayer(player);
        ((PreGameScreen)this.graphwar.getUI().getScreen(1)).addChat(null, player.getName() + " has joined the game.");
        this.graphwar.getGlobalClient().sendRoomStatus();
    }

    private void addChatMessage(String[] stringArray) throws Exception {
        int n = Integer.parseInt(stringArray[1]);
        String string = URLDecoder.decode(stringArray[2], "UTF-8");
        Player player = this.getPlayer(n);
        if (this.gameState == 1) {
            ((PreGameScreen)this.graphwar.getUI().getScreen(1)).addChat(player, string);
        } else if (this.gameState == 2) {
            ((GameScreen)this.graphwar.getUI().getScreen(3)).addChat(player, string);
        }
    }

    private void handleCommands(String string) {
        if (string.startsWith("-")) {
            if (string.compareToIgnoreCase("-sayfunc") == 0) {
                this.sayFunc = true;
            } else if (string.compareToIgnoreCase("-stopsayfunc") == 0) {
                this.sayFunc = false;
            } else if (string.compareToIgnoreCase("-shownext") == 0) {
                ((GameScreen)this.graphwar.getUI().getScreen(3)).setNextMarker(true);
            } else if (string.compareToIgnoreCase("-stopshownext") == 0) {
                ((GameScreen)this.graphwar.getUI().getScreen(3)).setNextMarker(false);
            }
        }
    }

    private void setModeMessage(String[] stringArray) throws Exception {
        int n;
        this.gameMode = n = Integer.parseInt(stringArray[1]);
        ((PreGameScreen)this.graphwar.getUI().getScreen(1)).setMode(n);
        this.graphwar.getGlobalClient().sendRoomStatus();
    }

    private void setReadyMessage(String[] stringArray) throws Exception {
        int n = Integer.parseInt(stringArray[1]);
        boolean bl = Integer.parseInt(stringArray[2]) != 0;
        Player player = this.getPlayer(n);
        player.setReady(bl);
        if (this.gameState == 1) {
            ((PreGameScreen)this.graphwar.getUI().getScreen(1)).repaint();
        }
        if (player.isLocalPlayer()) {
            this.updateReadyButton();
        }
        if (!bl && this.countingDown) {
            if (this.countdowner != null) {
                this.countdowner.stop();
            }
            this.displaySystemMessage("Game start cancelled.");
        }
    }

    private void updateReadyButton() {
        ListIterator<Player> listIterator = this.players.listIterator();
        boolean bl = true;
        while (listIterator.hasNext()) {
            Player player = listIterator.next();
            if (!player.isLocalPlayer() || player.getReady()) continue;
            bl = false;
            break;
        }
        ((PreGameScreen)this.graphwar.getUI().getScreen(1)).setReadyButtonOn(bl);
    }

    private void stopComputers() {
        ListIterator<Player> listIterator = this.players.listIterator();
        while (listIterator.hasNext()) {
            Player player = listIterator.next();
            if (!(player instanceof ComputerPlayer)) continue;
            ((ComputerPlayer)player).stopThinkFunction();
        }
    }

    private void startGameMessage(String[] stringArray) throws Exception {
        this.graphwar.getGlobalClient().hideRoom();
        this.stopComputers();
        this.gameState = 2;
        this.drawingFunction = false;
        this.exploding = false;
        int n = Integer.parseInt(stringArray[1]);
        int[] nArray = new int[n * 3];
        for (int i = 0; i < n * 3; ++i) {
            nArray[i] = Integer.parseInt(stringArray[2 + i]);
        }
        this.obstacle = new Obstacle(n, nArray);
        ListIterator<Player> listIterator = this.players.listIterator();
        int n2 = 3 * n + 2;
        while (listIterator.hasNext()) {
            Player player = listIterator.next();
            int n3 = player.getNumSoldiers();
            for (int i = 0; i < n3; ++i) {
                int n4 = Integer.parseInt(stringArray[n2]);
                int n5 = Integer.parseInt(stringArray[n2 + 1]);
                n2 += 2;
                player.startSoldier(i, n4, n5);
            }
            player.restartTurn();
        }
        int n6 = Math.abs(Integer.parseInt(stringArray[n2]));
        this.currentTurn = n6 %= this.players.size();
        this.timeTurnStarted = System.currentTimeMillis();
        Player player = this.players.get(this.currentTurn);
        if (player.isLocalPlayer()) {
            if (player instanceof ComputerPlayer) {
                ((ComputerPlayer)player).thinkFunction();
            } else {
                this.lastLocalHumanPlayer = player;
            }
        }
        this.graphwar.getUI().setScreen(3);
        ((GameScreen)this.graphwar.getUI().getScreen(3)).refreshFunction();
        ((GameScreen)this.graphwar.getUI().getScreen(3)).refreshSoldiers();
        ((GameScreen)this.graphwar.getUI().getScreen(3)).refreshBack();
    }

    private void nextTurnMessage(String[] stringArray) throws Exception {
        Player player;
        if (this.checkGameFinished()) {
            String string = "40";
            this.serverConnection.sendMessage(string);
        }
        int n = this.players.size();
        for (int i = 0; i < n; ++i) {
            this.currentTurn = (this.currentTurn + 1) % n;
            if (this.players.get(this.currentTurn).nextTurn()) break;
        }
        if ((player = this.players.get(this.currentTurn)).isLocalPlayer()) {
            if (player instanceof ComputerPlayer) {
                ((ComputerPlayer)player).thinkFunction();
            } else {
                this.lastLocalHumanPlayer = player;
            }
        }
        this.timeTurnStarted = System.currentTimeMillis();
        this.turnTimeUp = false;
        this.drawingFunction = false;
        this.exploding = false;
        this.nextTurnSent = false;
        ((GameScreen)this.graphwar.getUI().getScreen(3)).repaintAngle();
        ((GameScreen)this.graphwar.getUI().getScreen(3)).refreshFunction();
        ((GameScreen)this.graphwar.getUI().getScreen(3)).refreshBack();
    }

    private void fireFunctionMessage(String[] stringArray) throws Exception {
        if (stringArray.length == 3 && !this.drawingFunction) {
            int n = Integer.parseInt(stringArray[1]);
            String string = URLDecoder.decode(stringArray[2], "UTF-8");
            if (this.players.get(this.currentTurn).getID() == n) {
                Player player = this.getPlayer(n);
                this.processFunction(player, string);
                this.drawingFunction = true;
                this.timeStartedDrawingFunction = System.currentTimeMillis();
                ((GameScreen)this.graphwar.getUI().getScreen(3)).startDrawingFunction();
                if (this.sayFunc) {
                    ((GameScreen)this.graphwar.getUI().getScreen(3)).addChat(player, string);
                }
            }
        }
    }

    private void updateFunctionMessage(String[] stringArray) throws Exception {
        if (stringArray.length == 3 && !this.drawingFunction) {
            int n = Integer.parseInt(stringArray[1]);
            String string = URLDecoder.decode(stringArray[2], "UTF-8");
            Player player = this.getPlayer(n);
            if (this.players.get(this.currentTurn).getID() == n && !player.isLocalPlayer()) {
                ((GameScreen)this.graphwar.getUI().getScreen(3)).updateFunction(string);
            }
        }
    }

    public boolean isDrawingFunction() {
        return this.drawingFunction;
    }

    public Function getFunction() {
        return this.function;
    }

    public boolean isExploding() {
        return this.exploding;
    }

    public synchronized long getTimeExploding() {
        long l = System.currentTimeMillis() - this.timeStartedExploding;
        if (l > 3000L && this.exploding && !this.nextTurnSent) {
            this.nextTurn();
            this.nextTurnSent = true;
        }
        return l;
    }

    public void updateDrawingStuff() {
        if (this.isDrawingFunction()) {
            this.getCurrentFunctionPosition();
        }
        if (this.isExploding()) {
            this.getTimeExploding();
        }
        this.getRemainingTime();
    }

    public synchronized int getCurrentFunctionPosition() {
        if (this.exploding) {
            return this.function.getNumSteps();
        }
        int n = (int)((System.currentTimeMillis() - this.timeStartedDrawingFunction) * 1500L) / 1000;
        if (n > this.function.getNumSteps() && this.drawingFunction) {
            n = this.function.getNumSteps();
            this.exploding = true;
            this.timeStartedExploding = System.currentTimeMillis();
            if (this.isFunctionReversed()) {
                this.obstacle.setExplosion(770 - (int)this.function.getLastX(), (int)this.function.getLastY(), 12);
            } else {
                this.obstacle.setExplosion((int)this.function.getLastX(), (int)this.function.getLastY(), 12);
            }
            this.obstacle.explodePoint();
        }
        ListIterator<Soldier> listIterator = this.soldiersHit.listIterator();
        while (listIterator.hasNext()) {
            Soldier soldier = listIterator.next();
            if (!soldier.isAlive()) continue;
            if (soldier.isExploding()) {
                if (soldier.getTimeExploding() <= 6000L) continue;
                soldier.setExploding(false);
                continue;
            }
            if (n <= soldier.getKillPosition()) continue;
            soldier.setExploding(true);
            soldier.setAlive(false);
        }
        return n;
    }

    private void processFunction(Player player, String string) throws MalformedFunction {
        this.function = new Function(string);
        player.getCurrentTurnSoldier().setFunction(string);
        if (player.getTeam() == 1) {
            switch (this.gameMode) {
                case 0: {
                    this.function.processFunctionRange(this.obstacle, this.players.toArray(new Player[0]), this.players.size(), this.currentTurn, false);
                    break;
                }
                case 1: {
                    this.function.processRK4Range(this.obstacle, this.players.toArray(new Player[0]), this.players.size(), this.currentTurn, false);
                    break;
                }
                case 2: {
                    this.function.processRK42Range(this.obstacle, this.players.toArray(new Player[0]), this.players.size(), this.currentTurn, player.getCurrentTurnSoldier().getAngle(), false);
                }
            }
        } else {
            switch (this.gameMode) {
                case 0: {
                    this.function.processFunctionRange(this.obstacle, this.players.toArray(new Player[0]), this.players.size(), this.currentTurn, true);
                    break;
                }
                case 1: {
                    this.function.processRK4Range(this.obstacle, this.players.toArray(new Player[0]), this.players.size(), this.currentTurn, true);
                    break;
                }
                case 2: {
                    this.function.processRK42Range(this.obstacle, this.players.toArray(new Player[0]), this.players.size(), this.currentTurn, player.getCurrentTurnSoldier().getAngle(), true);
                }
            }
        }
        this.soldiersHit = new ArrayList();
        int n = this.function.getNumPlayersHit();
        for (int i = 0; i < n; ++i) {
            Soldier soldier = this.players.get(this.function.getPlayerHit(i)).getSoldiers()[this.function.getSoldierHit(i)];
            soldier.setKillPosition(this.function.getSoldierHitPosition(i));
            this.soldiersHit.add(soldier);
        }
        player.getCurrentTurnSoldier().setAngle(this.function.getFireAngle());
        ((GameScreen)this.graphwar.getUI().getScreen(3)).repaintAngle();
    }

    private void removeDisconnectedPlayers() {
        ListIterator<Player> listIterator = this.players.listIterator();
        while (listIterator.hasNext()) {
            Player player = listIterator.next();
            if (!player.isDisconnected()) continue;
            listIterator.remove();
        }
    }

    private void finishGameMessage(String[] stringArray) throws Exception {
        this.gameState = 1;
        this.drawingFunction = false;
        this.exploding = false;
        this.nextTurnSent = false;
        this.stopComputers();
        ((GameScreen)this.graphwar.getUI().getScreen(3)).stopPanel();
        Thread.sleep(200L);
        ListIterator<Player> listIterator = this.players.listIterator();
        block0: while (listIterator.hasNext()) {
            Player player = listIterator.next();
            Soldier[] soldierArray = player.getSoldiers();
            for (int i = 0; i < soldierArray.length; ++i) {
                if (!soldierArray[i].isAlive()) continue;
                ((PreGameScreen)this.graphwar.getUI().getScreen(1)).addChat(null, player.getName() + " won the game.");
                continue block0;
            }
        }
        this.removeDisconnectedPlayers();
        this.updateReadyButton();
        this.graphwar.getUI().setScreen(1);
        this.graphwar.getGlobalClient().recreateRoom();
    }

    private void setAngleMessage(String[] stringArray) throws Exception {
        int n = Integer.parseInt(stringArray[1]);
        int n2 = Integer.parseInt(stringArray[2]);
        double d = Double.parseDouble(stringArray[3]);
        Player player = this.getPlayer(n);
        if (!player.isLocalPlayer()) {
            player.getSoldiers()[n2].setAngle(d);
            ((GameScreen)this.graphwar.getUI().getScreen(3)).repaintAngle();
        }
    }

    private void setLeaderMessage(String[] stringArray) throws Exception {
        this.leader = true;
        ((PreGameScreen)this.graphwar.getUI().getScreen(1)).refreshBoard();
        ((PreGameScreen)this.graphwar.getUI().getScreen(1)).addChat(null, "You are now the room leader.");
    }

    protected synchronized void displaySystemMessage(String string) {
        ((PreGameScreen)this.graphwar.getUI().getScreen(1)).addChat(null, string);
    }

    private void startCountdownMessage(String[] stringArray) throws Exception {
        if (!this.countingDown) {
            if (this.countdowner != null) {
                this.countdowner.stop();
            }
            this.countdowner = new Countdowner(this);
        }
    }

    private void reorderMessage(String[] stringArray) throws Exception {
        ArrayList<Player> arrayList = new ArrayList<Player>();
        for (int i = 1; i < stringArray.length; ++i) {
            arrayList.add(this.getPlayer(Integer.parseInt(stringArray[i])));
        }
        this.players = arrayList;
    }

    public synchronized void handleMessage(String string) {
        String[] stringArray = string.split("&");
        try {
            int n = Integer.parseInt(stringArray[0]);
            switch (n) {
                case 10: {
                    break;
                }
                case 16: {
                    this.addPlayerMessage(stringArray);
                    break;
                }
                case 20: {
                    this.setSideMessage(stringArray);
                    break;
                }
                case 29: {
                    this.removePlayerMessage(stringArray);
                    break;
                }
                case 17: {
                    this.addSoldierMessage(stringArray);
                    break;
                }
                case 19: {
                    this.removeSoldierMessage(stringArray);
                    break;
                }
                case 14: {
                    this.addChatMessage(stringArray);
                    break;
                }
                case 33: {
                    this.setModeMessage(stringArray);
                    break;
                }
                case 21: {
                    this.setReadyMessage(stringArray);
                    break;
                }
                case 22: {
                    this.startGameMessage(stringArray);
                    break;
                }
                case 25: {
                    this.nextTurnMessage(stringArray);
                    break;
                }
                case 24: {
                    this.fireFunctionMessage(stringArray);
                    break;
                }
                case 40: {
                    this.finishGameMessage(stringArray);
                    break;
                }
                case 28: {
                    this.setAngleMessage(stringArray);
                    break;
                }
                case 41: {
                    this.setLeaderMessage(stringArray);
                    break;
                }
                case 42: {
                    this.startCountdownMessage(stringArray);
                    break;
                }
                case 43: {
                    this.reorderMessage(stringArray);
                    break;
                }
                case 44: {
                    this.updateFunctionMessage(stringArray);
                    break;
                }
                case 38: 
                case 39: {
                    this.serverConnection.disconnect();
                    this.kickFromGame();
                }
            }
        }
        catch (Exception exception) {
            this.invalidMessage(string);
            exception.printStackTrace();
        }
    }

    private void invalidMessage(String string) {
        System.out.println("Invalid message received: " + string);
    }

    public void kickFromGame() {
        if (this.gameState == 1) {
            ((PreGameScreen)this.graphwar.getUI().getScreen(1)).showMessage("You have been disconnected.");
        } else if (this.gameState == 2) {
            ((GameScreen)this.graphwar.getUI().getScreen(3)).showMessage("You have been disconnected.");
            ((GameScreen)this.graphwar.getUI().getScreen(3)).stopPanel();
        }
        this.gameState = 0;
        this.serverConnection = null;
        this.drawingFunction = false;
        this.exploding = false;
        this.nextTurnSent = false;
        this.leader = false;
    }

    public void stopGame() {
        this.gameState = 0;
        this.serverConnection = null;
        this.drawingFunction = false;
        this.exploding = false;
        this.nextTurnSent = false;
        this.leader = false;
        this.stopComputers();
        ((GlobalScreen)this.graphwar.getUI().getScreen(2)).refreshGameButton();
        ((PreGameScreen)this.graphwar.getUI().getScreen(1)).restartScreen();
        if (this.graphwar.getGlobalClient().isRunning()) {
            this.graphwar.getUI().setScreen(2);
        } else {
            this.graphwar.getUI().setScreen(0);
        }
        this.graphwar.finishGame();
    }

    public void disconnectKick() {
        String string = "39";
        this.serverConnection.sendMessage(string);
        this.serverConnection.disconnect();
        this.kickFromGame();
    }

    public void disconnect() {
        String string = "39";
        this.serverConnection.sendMessage(string);
        this.serverConnection.disconnect();
        this.stopGame();
    }

    @Override
    public void run() {
        while (this.gameState != 0) {
            if (this.gameState == 2) {
                this.updateDrawingStuff();
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    private class Countdowner
    implements Runnable {
        GameData gameData;
        Thread thisThread;

        public Countdowner(GameData gameData2) {
            this.gameData = gameData2;
            this.thisThread = new Thread(this);
            this.thisThread.start();
        }

        public void stop() {
            GameData.this.countingDown = false;
            this.thisThread.interrupt();
        }

        @Override
        public void run() {
            GameData.this.countingDown = true;
            for (int i = 5; i > 0 && GameData.this.countingDown; --i) {
                this.gameData.displaySystemMessage("Game starting in " + i + "...");
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            GameData.this.countingDown = false;
        }
    }
}

