/*
 * Decompiled with CFR 0.152.
 */
package Graphwar;

import GraphServer.Constants;
import Graphwar.ComputerPlayer;
import Graphwar.GlobalScreen;
import Graphwar.GraphAngleDisplay;
import Graphwar.GraphButton;
import Graphwar.GraphPlane;
import Graphwar.GraphTextBox;
import Graphwar.GraphTimer;
import Graphwar.GraphUtil;
import Graphwar.Graphwar;
import Graphwar.Player;
import Graphwar.PreGameScreen;
import Graphwar.StartStopPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Stack;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class GameScreen
extends JPanel
implements ActionListener,
StartStopPanel,
KeyListener,
MouseListener {
    private Graphwar graphwar;
    private JLabel[] backgroundImages;
    private JLabel yImg;
    private JLabel dyImg;
    private JLabel ddyImg;
    private GraphButton fire;
    private GraphButton quit;
    private GraphButton global;
    private JTextField funcField;
    private JTextField chatField;
    private GraphTextBox chatBox;
    private GraphPlane plane;
    private GraphTimer timer;
    private GraphAngleDisplay angleDisplay;
    private JLabel[] backgroundsQuit;
    private GraphButton yesQuit;
    private GraphButton noQuit;
    private boolean quitVisible;
    private JLabel[] backgroundsShowMessage;
    private GraphButton okButton;
    private JLabel messageLabel;
    private boolean showMessageVisible;

    public GameScreen(Graphwar graphwar, String string) throws Exception {
        int n;
        this.graphwar = graphwar;
        this.setLayout(null);
        this.setBounds(0, 0, 800, 600);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(graphwar.getClass().getResourceAsStream(string)));
        Stack<Component> stack = new Stack<Component>();
        int n2 = Integer.parseInt(GraphUtil.nextLine(bufferedReader));
        this.backgroundImages = new JLabel[n2];
        for (n = 0; n < n2; ++n) {
            this.backgroundImages[n] = GraphUtil.makeBackgroundImage(graphwar, bufferedReader);
            stack.push(this.backgroundImages[n]);
        }
        this.yImg = GraphUtil.makeBackgroundImage(graphwar, bufferedReader);
        this.dyImg = GraphUtil.makeBackgroundImage(graphwar, bufferedReader);
        this.ddyImg = GraphUtil.makeBackgroundImage(graphwar, bufferedReader);
        this.fire = GraphUtil.makeButton(graphwar, bufferedReader);
        this.quit = GraphUtil.makeButton(graphwar, bufferedReader);
        this.global = GraphUtil.makeButton(graphwar, bufferedReader);
        this.funcField = GraphUtil.makeTextField(bufferedReader);
        this.chatField = GraphUtil.makeTextField(bufferedReader);
        this.chatBox = GraphUtil.makeTextBox(bufferedReader);
        this.plane = new GraphPlane(graphwar);
        this.plane.setBounds(15, 15, 770, 450);
        this.timer = new GraphTimer(graphwar);
        this.timer.setBounds(221, 564, 57, 22);
        this.angleDisplay = new GraphAngleDisplay(graphwar);
        this.angleDisplay.setBounds(10, 475, 200, 113);
        stack.push(this.yImg);
        stack.push(this.dyImg);
        stack.push(this.ddyImg);
        stack.push(this.angleDisplay);
        stack.push(this.fire);
        stack.push(this.quit);
        stack.push(this.global);
        stack.push(this.plane);
        stack.push(this.funcField);
        stack.push(this.chatField);
        stack.push(this.chatBox);
        stack.push(this.timer);
        this.fire.addActionListener(this);
        this.quit.addActionListener(this);
        this.global.addActionListener(this);
        this.funcField.addActionListener(this);
        this.chatField.addActionListener(this);
        this.dyImg.setVisible(false);
        this.ddyImg.setVisible(false);
        this.global.setVisible(false);
        n2 = Integer.parseInt(GraphUtil.nextLine(bufferedReader));
        this.backgroundsQuit = new JLabel[n2];
        for (n = 0; n < n2; ++n) {
            this.backgroundsQuit[n] = GraphUtil.makeBackgroundImage(graphwar, bufferedReader);
            stack.push(this.backgroundsQuit[n]);
        }
        this.yesQuit = GraphUtil.makeButton(graphwar, bufferedReader);
        this.noQuit = GraphUtil.makeButton(graphwar, bufferedReader);
        stack.push(this.yesQuit);
        stack.push(this.noQuit);
        this.showQuit(false);
        this.yesQuit.addActionListener(this);
        this.noQuit.addActionListener(this);
        n2 = Integer.parseInt(GraphUtil.nextLine(bufferedReader));
        this.backgroundsShowMessage = new JLabel[n2];
        for (n = 0; n < n2; ++n) {
            this.backgroundsShowMessage[n] = GraphUtil.makeBackgroundImage(graphwar, bufferedReader);
            stack.push(this.backgroundsShowMessage[n]);
        }
        this.okButton = GraphUtil.makeButton(graphwar, bufferedReader);
        this.messageLabel = GraphUtil.makeTextLabel(bufferedReader);
        stack.push(this.okButton);
        stack.push(this.messageLabel);
        this.messageLabel.setFont(new Font("Sans", 1, 20));
        this.messageLabel.setForeground(Color.ORANGE);
        this.messageLabel.setHorizontalAlignment(0);
        this.messageLabel.setVerticalAlignment(0);
        this.showShowMessage(false);
        this.okButton.addActionListener(this);
        this.funcField.addKeyListener(this);
        this.chatField.addKeyListener(this);
        this.addMouseListener(this);
        this.plane.addMouseListener(this);
        this.angleDisplay.addMouseListener(this);
        this.setFocusable(true);
        this.addKeyListener(this);
        this.addComponentsReversed(this, stack);
        this.revalidate();
    }

    private void addComponentsReversed(JPanel jPanel, Stack<Component> stack) {
        while (!stack.empty()) {
            jPanel.add(stack.pop());
        }
    }

    public void setNextMarker(boolean bl) {
        this.plane.setNextMarker(bl);
    }

    private void showShowMessage(boolean bl) {
        final boolean bl2 = bl;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GameScreen.this.okButton.setVisible(bl2);
                GameScreen.this.messageLabel.setVisible(bl2);
                for (int i = 0; i < GameScreen.this.backgroundsShowMessage.length; ++i) {
                    GameScreen.this.backgroundsShowMessage[i].setVisible(bl2);
                }
                GameScreen.this.showMessageVisible = bl2;
                GameScreen.this.repaint();
            }
        });
    }

    private void showQuit(boolean bl) {
        final boolean bl2 = bl;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GameScreen.this.yesQuit.setVisible(bl2);
                GameScreen.this.noQuit.setVisible(bl2);
                GameScreen.this.quitVisible = bl2;
                for (int i = 0; i < GameScreen.this.backgroundsQuit.length; ++i) {
                    GameScreen.this.backgroundsQuit[i].setVisible(bl2);
                }
            }
        });
    }

    public void refreshGlobalButton() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (GameScreen.this.graphwar.getGlobalClient().isRunning()) {
                    GameScreen.this.global.setVisible(true);
                } else {
                    GameScreen.this.global.setVisible(false);
                }
                GameScreen.this.repaint();
            }
        });
    }

    @Override
    public void paint(Graphics graphics) {
        this.plane.refreshBackground();
        super.paint(graphics);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        graphics.setColor(Constants.BACKGROUND);
        graphics.fillRect(0, 0, 800, 600);
    }

    public void addChat(Player player, String string) {
        String string2 = null;
        Color color = null;
        if (player != null) {
            string2 = player.getName();
            color = player.getColor();
        }
        this.chatBox.addText(string2, color, string);
    }

    public void showMessage(String string) {
        this.messageLabel.setText(string);
        this.showShowMessage(true);
    }

    public void refreshBack() {
        this.plane.refreshBackground();
    }

    public void refreshSoldiers() {
        this.plane.refreshSoldiers();
    }

    public void refreshFunction() {
        Player player = this.graphwar.getGameData().getCurrentTurnPlayer();
        if (player.isLocalPlayer() && !(player instanceof ComputerPlayer)) {
            final String string = player.getCurrentTurnSoldier().getFunction();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GameScreen.this.funcField.setEnabled(true);
                    GameScreen.this.funcField.setText(string);
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GameScreen.this.funcField.setEnabled(false);
                }
            });
        }
    }

    public boolean isShowMessageVisible() {
        return this.showMessageVisible;
    }

    public boolean isQuitVisible() {
        return this.quitVisible;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.quitVisible) {
            if (actionEvent.getSource() == this.noQuit) {
                this.showQuit(false);
                this.plane.refreshBackground();
                this.repaint();
            } else if (actionEvent.getSource() == this.yesQuit) {
                this.graphwar.getGameData().disconnect();
                this.graphwar.getGlobalClient().closeRoom();
                this.showQuit(false);
            }
        } else if (this.showMessageVisible) {
            if (actionEvent.getSource() == this.okButton) {
                ((GlobalScreen)this.graphwar.getUI().getScreen(2)).refreshGameButton();
                ((PreGameScreen)this.graphwar.getUI().getScreen(1)).restartScreen();
                if (this.graphwar.getGlobalClient().isRunning()) {
                    this.graphwar.getUI().setScreen(2);
                } else {
                    this.graphwar.getUI().setScreen(0);
                }
                this.graphwar.finishGame();
                this.showShowMessage(false);
            }
        } else if (actionEvent.getSource() == this.quit) {
            this.showQuit(true);
            this.repaint();
        } else if (actionEvent.getSource() == this.chatField) {
            String string = this.chatField.getText();
            if (!string.isEmpty()) {
                this.graphwar.getGameData().sendChatMessage(string);
                this.chatField.setText("");
            }
        } else if (actionEvent.getSource() == this.fire || actionEvent.getSource() == this.funcField) {
            String string;
            if (!(this.graphwar.getGameData().getCurrentTurnPlayer() instanceof ComputerPlayer) && (string = this.funcField.getText()).length() > 0) {
                this.graphwar.getGameData().sendFunction(string);
            }
        } else if (actionEvent.getSource() == this.global) {
            this.graphwar.getUI().setScreen(2);
        }
    }

    public void updateFunction(String string) {
        this.funcField.setText(string);
    }

    public void startDrawingFunction() {
        this.plane.startDrawingFunction();
    }

    public void repaintAngle() {
        this.angleDisplay.repaint();
    }

    private void showFuncType() {
        switch (this.graphwar.getGameData().getGameMode()) {
            case 0: {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GameScreen.this.dyImg.setVisible(false);
                        GameScreen.this.ddyImg.setVisible(false);
                        GameScreen.this.yImg.setVisible(true);
                        GameScreen.this.yImg.repaint();
                    }
                });
                break;
            }
            case 1: {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GameScreen.this.yImg.setVisible(false);
                        GameScreen.this.ddyImg.setVisible(false);
                        GameScreen.this.dyImg.setVisible(true);
                        GameScreen.this.dyImg.repaint();
                    }
                });
                break;
            }
            case 2: {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GameScreen.this.yImg.setVisible(false);
                        GameScreen.this.dyImg.setVisible(false);
                        GameScreen.this.ddyImg.setVisible(true);
                        GameScreen.this.ddyImg.repaint();
                    }
                });
            }
        }
    }

    @Override
    public void startPanel() {
        this.showFuncType();
        this.plane.startAnimating();
        this.timer.startRunning();
    }

    @Override
    public void stopPanel() {
        this.plane.stopAnimating();
        this.timer.stopRunning();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.graphwar.getGameData().getGameMode() == 2) {
            if (keyEvent.getKeyCode() == 38) {
                this.graphwar.getGameData().angleUp();
            } else if (keyEvent.getKeyCode() == 40) {
                this.graphwar.getGameData().angleDown();
            }
        }
        String string = this.funcField.getText();
        this.graphwar.getGameData().sendFunctionPreview(string);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (this.graphwar.getGameData().getGameMode() == 2 && (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40)) {
            this.graphwar.getGameData().stopAngle();
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.requestFocus();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

