/*
 * Decompiled with CFR 0.152.
 */
package Graphwar;

import GraphServer.Connection;
import Graphwar.GameScreen;
import Graphwar.GlobalScreen;
import Graphwar.Graphwar;
import Graphwar.PreGameScreen;
import Graphwar.Room;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class GlobalClient
implements Runnable {
    private Connection connection;
    private List<LobbyPlayer> players = new Vector<LobbyPlayer>();
    private List<Room> rooms = new Vector<Room>();
    private String localPlayer = "Player";
    private boolean running = false;
    private boolean roomCreated = false;
    private boolean roomHidden = false;
    private boolean roomInvalid = false;
    private String roomName = "Room";
    private int roomPort = 6112;
    private Graphwar graphwar;

    public GlobalClient(Graphwar graphwar) {
        this.graphwar = graphwar;
    }

    public String getLocalPlayerName() {
        return this.localPlayer;
    }

    public void joinGlobalServer(String string, int n, String string2) throws IOException {
        this.connection = new Connection(string, n);
        this.connection.sendMessage(URLEncoder.encode(string2, "UTF-8"));
        this.localPlayer = string2;
        this.running = true;
        new Thread(this).start();
        ((PreGameScreen)this.graphwar.getUI().getScreen(1)).refreshGlobalButton();
        ((GameScreen)this.graphwar.getUI().getScreen(3)).refreshGlobalButton();
    }

    public String getIP(int n) {
        return this.rooms.get(n).getIp();
    }

    public int getNumRooms() {
        return this.rooms.size();
    }

    public int getPort(int n) {
        return this.rooms.get(n).getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getGlobalPlayers() {
        String[] stringArray;
        int n = 0;
        List<LobbyPlayer> list = this.players;
        synchronized (list) {
            stringArray = new String[this.players.size()];
            ListIterator<LobbyPlayer> listIterator = this.players.listIterator();
            while (listIterator.hasNext()) {
                LobbyPlayer lobbyPlayer = listIterator.next();
                if (lobbyPlayer.getName().equals("SERVERPEWPEW")) continue;
                stringArray[n] = lobbyPlayer.getName();
                ++n;
            }
        }
        stringArray = Arrays.copyOf(stringArray, n);
        return stringArray;
    }

    public boolean isRoomInvalid() {
        return this.roomInvalid;
    }

    public List<Room> getRooms() {
        return this.rooms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPlayer(String string, int n) {
        LobbyPlayer lobbyPlayer = new LobbyPlayer(string, n);
        List<LobbyPlayer> list = this.players;
        synchronized (list) {
            this.players.add(lobbyPlayer);
        }
        ((GlobalScreen)this.graphwar.getUI().getScreen(2)).refreshPlayers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePlayer(int n) {
        List<LobbyPlayer> list = this.players;
        synchronized (list) {
            ListIterator<LobbyPlayer> listIterator = this.players.listIterator();
            while (listIterator.hasNext()) {
                LobbyPlayer lobbyPlayer = listIterator.next();
                if (lobbyPlayer.getID() != n) continue;
                this.players.remove(lobbyPlayer);
                break;
            }
        }
        ((GlobalScreen)this.graphwar.getUI().getScreen(2)).refreshPlayers();
    }

    private void removeRoom(int n) {
        ListIterator<Room> listIterator = this.rooms.listIterator();
        while (listIterator.hasNext()) {
            Room room = listIterator.next();
            if (room.getRoomID() != n) continue;
            this.rooms.remove(room);
            break;
        }
        ((GlobalScreen)this.graphwar.getUI().getScreen(2)).refreshRooms();
    }

    private void updateRoom(int n, int n2, int n3) {
        ListIterator<Room> listIterator = this.rooms.listIterator();
        while (listIterator.hasNext()) {
            Room room = listIterator.next();
            if (room.getRoomID() != n) continue;
            room.updateRoom(n3, n2);
            break;
        }
        ((GlobalScreen)this.graphwar.getUI().getScreen(2)).refreshRooms();
    }

    private void addRoom(String string, int n, String string2, int n2, int n3, int n4) {
        Room room = new Room(string, n, string2, n2, n3, n4);
        this.rooms.add(room);
        ((GlobalScreen)this.graphwar.getUI().getScreen(2)).refreshRooms();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToChat(int n, String string) {
        String string2 = "Anon";
        List<LobbyPlayer> list = this.players;
        synchronized (list) {
            ListIterator<LobbyPlayer> listIterator = this.players.listIterator();
            while (listIterator.hasNext()) {
                LobbyPlayer lobbyPlayer = listIterator.next();
                if (lobbyPlayer.getID() != n) continue;
                string2 = lobbyPlayer.getName();
                break;
            }
        }
        ((GlobalScreen)this.graphwar.getUI().getScreen(2)).addChat(string2, string);
    }

    private void handleMessage(String string) {
        String[] stringArray = new String[]{};
        if (string != null) {
            stringArray = string.split("&");
        }
        if (stringArray.length > 0) {
            int n = Integer.parseInt(stringArray[0]);
            switch (n) {
                case 10: {
                    break;
                }
                case 101: {
                    if (stringArray.length != 3) break;
                    try {
                        String string2 = URLDecoder.decode(stringArray[1], "UTF-8");
                        int n2 = Integer.parseInt(stringArray[2]);
                        this.addPlayer(string2, n2);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    break;
                }
                case 102: {
                    if (stringArray.length != 3) break;
                    try {
                        int n3 = Integer.parseInt(stringArray[1]);
                        String string3 = URLDecoder.decode(stringArray[2], "UTF-8");
                        this.addToChat(n3, string3);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    break;
                }
                case 105: {
                    if (stringArray.length != 4) break;
                    int n4 = Integer.parseInt(stringArray[1]);
                    int n5 = Integer.parseInt(stringArray[2]);
                    int n6 = Integer.parseInt(stringArray[3]);
                    this.updateRoom(n4, n5, n6);
                    break;
                }
                case 108: {
                    if (stringArray.length != 5) break;
                    try {
                        String string4 = URLDecoder.decode(stringArray[1], "UTF-8");
                        int n7 = Integer.parseInt(stringArray[2]);
                        String string5 = URLDecoder.decode(stringArray[3], "UTF-8");
                        int n8 = Integer.parseInt(stringArray[4]);
                        this.addRoom(string4, n7, string5, n8, 0, 0);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    break;
                }
                case 103: {
                    if (stringArray.length < 2) break;
                    this.players.clear();
                    int n9 = Integer.parseInt(stringArray[1]);
                    for (int i = 0; i < n9; ++i) {
                        try {
                            String string6 = URLDecoder.decode(stringArray[2 + 2 * i], "UTF-8");
                            int n10 = Integer.parseInt(stringArray[3 + 2 * i]);
                            this.addPlayer(string6, n10);
                            continue;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    break;
                }
                case 104: {
                    if (stringArray.length < 2) break;
                    this.rooms.clear();
                    int n11 = Integer.parseInt(stringArray[1]);
                    for (int i = 0; i < n11; ++i) {
                        try {
                            String string7 = URLDecoder.decode(stringArray[2 + 6 * i], "UTF-8");
                            int n12 = Integer.parseInt(stringArray[3 + 6 * i]);
                            String string8 = URLDecoder.decode(stringArray[4 + 6 * i], "UTF-8");
                            int n13 = Integer.parseInt(stringArray[5 + 6 * i]);
                            int n14 = Integer.parseInt(stringArray[6 + 6 * i]);
                            int n15 = Integer.parseInt(stringArray[7 + 6 * i]);
                            this.addRoom(string7, n12, string8, n13, n14, n15);
                            continue;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    break;
                }
                case 107: {
                    if (stringArray.length != 2) break;
                    int n16 = Integer.parseInt(stringArray[1]);
                    this.removeRoom(n16);
                    break;
                }
                case 109: {
                    this.roomInvalid = true;
                    this.graphwar.getUI().getScreen(1).repaint();
                    break;
                }
                case 106: {
                    if (stringArray.length != 2) break;
                    int n17 = Integer.parseInt(stringArray[1]);
                    this.removePlayer(n17);
                }
            }
        }
    }

    public void sendChatMessage(String string) {
        try {
            String string2 = "102&" + URLEncoder.encode(string, "UTF-8");
            this.connection.sendMessage(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void recreateRoom() {
        if (this.roomHidden) {
            this.roomCreated = true;
            this.roomHidden = false;
            this.roomInvalid = false;
            try {
                String string = "108&" + URLEncoder.encode(this.roomName, "UTF-8") + "&" + this.roomPort;
                this.connection.sendMessage(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void createRoom(String string, int n) {
        this.roomName = string;
        this.roomPort = n;
        this.roomCreated = true;
        try {
            String string2 = "108&" + URLEncoder.encode(string, "UTF-8") + "&" + n;
            this.connection.sendMessage(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void closeRoom() {
        if (this.roomCreated) {
            this.roomCreated = false;
            this.roomHidden = false;
            this.roomInvalid = false;
            this.connection.sendMessage("107");
        }
    }

    public void hideRoom() {
        if (this.roomCreated) {
            this.roomCreated = false;
            this.roomHidden = true;
            this.connection.sendMessage("107");
        }
    }

    private void quitGlobal() {
        String string = "106";
        this.connection.sendMessage(string);
    }

    public boolean isRunning() {
        return this.running;
    }

    public void stop() {
        if (this.roomCreated) {
            this.closeRoom();
        }
        this.quitGlobal();
        this.disconnect(false);
        ((PreGameScreen)this.graphwar.getUI().getScreen(1)).refreshGlobalButton();
        ((GameScreen)this.graphwar.getUI().getScreen(3)).refreshGlobalButton();
    }

    public void sendRoomStatus() {
        if (this.roomCreated) {
            String string = "105&" + this.graphwar.getGameData().getGameMode() + "&" + this.graphwar.getGameData().getPlayers().size();
            this.connection.sendMessage(string);
        }
    }

    public boolean checkTimeout() {
        return System.currentTimeMillis() - this.connection.getLastReceivedTime() > 30000L;
    }

    public boolean checkStayAliveTime() {
        return System.currentTimeMillis() - this.connection.getLastSentTime() > 5000L;
    }

    private void disconnect(boolean bl) {
        if (bl && this.running) {
            ((GlobalScreen)this.graphwar.getUI().getScreen(2)).showDisconnectMessage("You have been disconnected.");
        }
        this.running = false;
        ((GameScreen)this.graphwar.getUI().getScreen(3)).refreshGlobalButton();
        try {
            this.connection.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void sendMessage(String string) {
        this.connection.sendMessage(string);
    }

    public void sendKeepAlive() {
        this.connection.sendMessage("10");
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                String string = this.connection.readMessage();
                if (string == null) {
                    this.disconnect(true);
                    continue;
                }
                this.handleMessage(string);
                if (!this.checkStayAliveTime()) continue;
                this.sendKeepAlive();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                if (this.checkTimeout()) {
                    this.disconnect(true);
                    continue;
                }
                this.sendKeepAlive();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.disconnect(true);
            }
        }
    }

    private class LobbyPlayer {
        private String name;
        private int playerID;

        public LobbyPlayer(String string, int n) {
            this.name = string;
            this.playerID = n;
        }

        public String getName() {
            return this.name;
        }

        public int getID() {
            return this.playerID;
        }
    }
}

