/*
 * Decompiled with CFR 0.152.
 */
package Graphwar;

import GraphServer.Constants;
import Graphwar.GlobalPlayerBoard;
import Graphwar.GraphButton;
import Graphwar.GraphTextBox;
import Graphwar.GraphUtil;
import Graphwar.Graphwar;
import Graphwar.RoomBoard;
import Graphwar.StartStopPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Stack;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class GlobalScreen
extends JPanel
implements ActionListener,
StartStopPanel {
    private Graphwar graphwar;
    private JLabel[] backgroundImages;
    private String message;
    private int messageX;
    private boolean showMessage;
    private GraphButton createButton;
    private GraphButton gameRoomButton;
    private GraphButton backButton;
    private JTextField chatField;
    private GraphTextBox chatBox;
    private GlobalPlayerBoard playerBoard;
    private RoomBoard roomBoard;
    private JLabel[] backgroundsCreate;
    private JTextField nameFieldCreate;
    private JTextField portFieldCreate;
    private GraphButton yesButtonCreate;
    private GraphButton noButtonCreate;
    private boolean createVisible;
    private JLabel[] backgroundsShowMessage;
    private GraphButton okButton;
    private JLabel messageLabel;
    private boolean showMessageVisible;
    private static Font font = new Font("Sans", 1, 12);

    public GlobalScreen(Graphwar graphwar, String string) throws InterruptedException, IOException {
        int n;
        this.graphwar = graphwar;
        this.setLayout(null);
        this.setBounds(0, 0, 800, 600);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(graphwar.getClass().getResourceAsStream(string)));
        Stack<Component> stack = new Stack<Component>();
        int n2 = Integer.parseInt(GraphUtil.nextLine(bufferedReader));
        this.backgroundImages = new JLabel[n2];
        for (int i = 0; i < n2; ++i) {
            this.backgroundImages[i] = GraphUtil.makeBackgroundImage(graphwar, bufferedReader);
            stack.push(this.backgroundImages[i]);
        }
        this.createButton = GraphUtil.makeButton(graphwar, bufferedReader);
        this.gameRoomButton = GraphUtil.makeButton(graphwar, bufferedReader);
        this.backButton = GraphUtil.makeButton(graphwar, bufferedReader);
        this.chatField = GraphUtil.makeTextField(bufferedReader);
        this.chatBox = GraphUtil.makeTextBox(bufferedReader);
        this.playerBoard = new GlobalPlayerBoard(graphwar, 180, 367);
        this.playerBoard.setPreferredSize(new Dimension(180, 367));
        JScrollPane jScrollPane = new JScrollPane(this.playerBoard);
        jScrollPane.setBounds(585, 50, 200, 370);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        this.roomBoard = new RoomBoard(graphwar, 380, 197);
        this.roomBoard.setPreferredSize(new Dimension(380, 197));
        JScrollPane jScrollPane2 = new JScrollPane(this.roomBoard);
        jScrollPane2.setBounds(15, 50, 400, 200);
        jScrollPane2.setVerticalScrollBarPolicy(22);
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        stack.push(this.createButton);
        stack.push(this.gameRoomButton);
        stack.push(this.backButton);
        stack.push(this.chatField);
        stack.push(this.chatBox);
        stack.push(jScrollPane);
        stack.push(jScrollPane2);
        this.createButton.addActionListener(this);
        this.gameRoomButton.addActionListener(this);
        this.backButton.addActionListener(this);
        this.chatField.addActionListener(this);
        this.gameRoomButton.setVisible(false);
        n2 = Integer.parseInt(GraphUtil.nextLine(bufferedReader));
        this.backgroundsCreate = new JLabel[n2];
        for (n = 0; n < n2; ++n) {
            this.backgroundsCreate[n] = GraphUtil.makeBackgroundImage(graphwar, bufferedReader);
            stack.push(this.backgroundsCreate[n]);
        }
        this.nameFieldCreate = GraphUtil.makeTextField(bufferedReader);
        this.portFieldCreate = GraphUtil.makeTextField(bufferedReader);
        this.yesButtonCreate = GraphUtil.makeButton(graphwar, bufferedReader);
        this.noButtonCreate = GraphUtil.makeButton(graphwar, bufferedReader);
        stack.push(this.nameFieldCreate);
        stack.push(this.portFieldCreate);
        stack.push(this.yesButtonCreate);
        stack.push(this.noButtonCreate);
        this.showCreateGame(false);
        this.nameFieldCreate.addActionListener(this);
        this.portFieldCreate.addActionListener(this);
        this.yesButtonCreate.addActionListener(this);
        this.noButtonCreate.addActionListener(this);
        n2 = Integer.parseInt(GraphUtil.nextLine(bufferedReader));
        this.backgroundsShowMessage = new JLabel[n2];
        for (n = 0; n < n2; ++n) {
            this.backgroundsShowMessage[n] = GraphUtil.makeBackgroundImage(graphwar, bufferedReader);
            stack.push(this.backgroundsShowMessage[n]);
        }
        this.okButton = GraphUtil.makeButton(graphwar, bufferedReader);
        this.messageLabel = GraphUtil.makeTextLabel(bufferedReader);
        stack.push(this.okButton);
        stack.push(this.messageLabel);
        this.messageLabel.setFont(new Font("Sans", 1, 20));
        this.messageLabel.setForeground(Color.ORANGE);
        this.messageLabel.setHorizontalAlignment(0);
        this.messageLabel.setVerticalAlignment(0);
        this.showShowMessage(false);
        this.okButton.addActionListener(this);
        this.addComponentsReversed(this, stack);
        this.revalidate();
    }

    private void addComponentsReversed(JPanel jPanel, Stack<Component> stack) {
        while (!stack.empty()) {
            jPanel.add(stack.pop());
        }
    }

    private void showShowMessage(boolean bl) {
        final boolean bl2 = bl;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GlobalScreen.this.okButton.setVisible(bl2);
                GlobalScreen.this.messageLabel.setVisible(bl2);
                for (int i = 0; i < GlobalScreen.this.backgroundsShowMessage.length; ++i) {
                    GlobalScreen.this.backgroundsShowMessage[i].setVisible(bl2);
                }
                GlobalScreen.this.showMessageVisible = bl2;
                GlobalScreen.this.repaint();
            }
        });
    }

    public void showMessage(String string) {
        this.showMessage = true;
        this.message = string;
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(Constants.NAME_FONT);
        int n = fontMetrics.stringWidth(string);
        this.messageX = (800 - n) / 2;
        this.repaint();
    }

    public void showDisconnectMessage(String string) {
        this.messageLabel.setText(string);
        this.showShowMessage(true);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        graphics.setColor(Constants.BACKGROUND);
        graphics.fillRect(0, 0, 800, 600);
        this.paintMessage(graphics);
    }

    public void paintMessage(Graphics graphics) {
        if (this.showMessage) {
            graphics.setFont(font);
            graphics.setColor(Color.red);
            graphics.drawString(this.message, this.messageX, 15);
        }
    }

    private void showCreateGame(boolean bl) {
        final boolean bl2 = bl;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GlobalScreen.this.nameFieldCreate.setVisible(bl2);
                GlobalScreen.this.portFieldCreate.setVisible(bl2);
                GlobalScreen.this.yesButtonCreate.setVisible(bl2);
                GlobalScreen.this.noButtonCreate.setVisible(bl2);
                GlobalScreen.this.createVisible = bl2;
                for (int i = 0; i < GlobalScreen.this.backgroundsCreate.length; ++i) {
                    GlobalScreen.this.backgroundsCreate[i].setVisible(bl2);
                }
                GlobalScreen.this.nameFieldCreate.setText(GlobalScreen.this.graphwar.getGlobalClient().getLocalPlayerName() + "'s Room");
                GlobalScreen.this.portFieldCreate.setText("6112");
            }
        });
    }

    public void refreshGameButton() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (GlobalScreen.this.graphwar.getGameData().getGameState() == 0) {
                    GlobalScreen.this.gameRoomButton.setVisible(false);
                } else {
                    GlobalScreen.this.gameRoomButton.setVisible(true);
                }
                GlobalScreen.this.repaint();
            }
        });
    }

    public void refreshPlayers() {
        this.repaint();
    }

    public void refreshRooms() {
        this.repaint();
    }

    public void addChat(String string, String string2) {
        this.chatBox.addText(string, Color.BLACK, string2);
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block30: {
            if (this.createVisible) {
                if (actionEvent.getSource() == this.noButtonCreate) {
                    this.showCreateGame(false);
                    this.showMessage = false;
                    this.repaint();
                } else if (actionEvent.getSource() == this.yesButtonCreate || actionEvent.getSource() == this.nameFieldCreate || actionEvent.getSource() == this.portFieldCreate) {
                    try {
                        String string = this.nameFieldCreate.getText();
                        int n = Integer.parseInt(this.portFieldCreate.getText());
                        if (string == null || string.length() == 0) break block30;
                        if (string.length() > 20) {
                            this.nameFieldCreate.setText(string.substring(0, 20));
                            break block30;
                        }
                        this.showMessage("Creating...");
                        try {
                            this.graphwar.createGame(n);
                            this.graphwar.getGlobalClient().createRoom(string, n);
                            this.graphwar.getGameData().addPlayer(this.graphwar.getGlobalClient().getLocalPlayerName());
                            this.showCreateGame(false);
                            this.showMessage = false;
                        }
                        catch (IOException iOException) {
                            this.showMessage("Failed! Check if port is not already in use.");
                            iOException.printStackTrace();
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.showMessage("Port must be a number.");
                    }
                }
            } else if (this.showMessageVisible) {
                if (actionEvent.getSource() == this.okButton) {
                    if (this.graphwar.getGameData().getGameState() == 0) {
                        this.graphwar.getUI().setScreen(0);
                        this.graphwar.finishGame();
                    } else if (this.graphwar.getGameData().getGameState() == 1) {
                        this.graphwar.getUI().setScreen(1);
                    } else if (this.graphwar.getGameData().getGameState() == 2) {
                        this.graphwar.getUI().setScreen(3);
                    }
                    this.showShowMessage(false);
                }
            } else if (actionEvent.getSource() == this.chatField) {
                this.graphwar.getGlobalClient().sendChatMessage(this.chatField.getText());
                this.chatField.setText("");
            } else if (actionEvent.getSource() == this.createButton) {
                if (this.graphwar.getGameData().getGameState() == 0) {
                    this.showCreateGame(true);
                    this.repaint();
                }
            } else if (actionEvent.getSource() == this.backButton) {
                this.graphwar.getGlobalClient().stop();
                if (this.graphwar.getGameData().getGameState() != 0) {
                    this.graphwar.getGameData().disconnect();
                    this.graphwar.finishGame();
                }
                this.graphwar.getUI().setScreen(0);
            } else if (actionEvent.getSource() == this.gameRoomButton) {
                if (this.graphwar.getGameData().getGameState() == 1) {
                    this.graphwar.getUI().setScreen(1);
                } else if (this.graphwar.getGameData().getGameState() == 2) {
                    this.graphwar.getUI().setScreen(3);
                }
            }
        }
    }

    @Override
    public void startPanel() {
        this.showMessage = false;
    }

    @Override
    public void stopPanel() {
    }
}

