/*
 * Decompiled with CFR 0.152.
 */
package Graphwar;

import Graphwar.Graphwar;
import Graphwar.Player;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JPanel;

public class GraphAngleDisplay
extends JPanel {
    private Graphwar graphwar;
    private static Font font = new Font("Sans", 0, 14);

    public GraphAngleDisplay(Graphwar graphwar) {
        this.graphwar = graphwar;
        this.setOpaque(false);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        double d;
        Player player = this.graphwar.getGameData().getCurrentTurnPlayer();
        if (this.graphwar.getGameData().isAngleDown() || this.graphwar.getGameData().isAngleUp()) {
            d = this.graphwar.getGameData().getAngle();
            this.repaint();
        } else {
            d = player.getCurrentTurnSoldier().getAngle();
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(player.getColor());
        this.paintCircle(graphics2D, d);
        this.paintAngleText(graphics2D, d);
    }

    private void paintCircle(Graphics graphics, double d) {
        boolean bl;
        boolean bl2 = bl = !(!this.graphwar.getGameData().isFunctionReversed() && !this.graphwar.getGameData().isTerrainReversed() || this.graphwar.getGameData().isFunctionReversed() && this.graphwar.getGameData().isTerrainReversed());
        if (bl) {
            graphics.fillArc(27, 27, 60, 60, 180, -((int)Math.toDegrees(d)));
        } else {
            graphics.fillArc(27, 27, 60, 60, 0, (int)Math.toDegrees(d));
        }
        graphics.setColor(Color.BLACK);
        graphics.drawLine(4, 57, 111, 57);
        graphics.drawLine(57, 5, 57, 111);
        if (bl) {
            graphics.drawLine(57, 57, 57 - (int)(53.0 * Math.cos(d)), 57 - (int)(53.0 * Math.sin(d)));
        } else {
            graphics.drawLine(57, 57, 57 + (int)(53.0 * Math.cos(d)), 57 - (int)(53.0 * Math.sin(d)));
        }
    }

    private void paintAngleText(Graphics graphics, double d) {
        graphics.setFont(font);
        graphics.setColor(Color.BLACK);
        graphics.setFont(font);
        double d2 = Math.toDegrees(d);
        int n = (int)((d2 *= 100.0) + 0.5);
        d2 = (double)n / 100.0;
        graphics.drawString(Double.toString(d2) + "\u00b0", 145, 108);
    }
}

