/*
 * Decompiled with CFR 0.152.
 */
package Graphwar;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.JButton;

public class GraphButton
extends JButton
implements MouseListener,
MouseMotionListener {
    private Image normalImg;
    private Image overImg;
    private BufferedImage maskImg;
    private boolean mouseOver;

    public GraphButton(Image image, Image image2, BufferedImage bufferedImage) {
        this.normalImg = image;
        this.overImg = image2;
        this.maskImg = bufferedImage;
        this.setOpaque(false);
        this.mouseOver = false;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void updateImages(Image image, Image image2, BufferedImage bufferedImage) {
        this.normalImg = image;
        this.overImg = image2;
        this.maskImg = bufferedImage;
        this.revalidate();
        this.repaint();
    }

    @Override
    public void setVisible(boolean bl) {
        if (!bl) {
            this.mouseOver = false;
        }
        super.setVisible(bl);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.mouseOver) {
            graphics.drawImage(this.overImg, 0, 0, null);
        } else {
            graphics.drawImage(this.normalImg, 0, 0, null);
        }
    }

    @Override
    public void paintBorder(Graphics graphics) {
    }

    @Override
    public boolean contains(int n, int n2) {
        if (0 <= n && this.maskImg.getWidth() > n && 0 <= n2 && this.maskImg.getHeight() > n2 && this.maskImg.getRGB(n, n2) != -1) {
            return true;
        }
        if (this.mouseOver) {
            this.mouseOver = false;
            this.repaint();
        }
        return false;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.contains(mouseEvent.getX(), mouseEvent.getY())) {
            if (!this.mouseOver) {
                this.mouseOver = true;
                this.repaint();
            }
        } else if (this.mouseOver) {
            this.mouseOver = false;
            this.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseOver = false;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

