/*
 * Decompiled with CFR 0.152.
 */
package Graphwar;

import GraphServer.Constants;
import Graphwar.Function;
import Graphwar.GameScreen;
import Graphwar.GraphUtil;
import Graphwar.Graphwar;
import Graphwar.Player;
import Graphwar.Soldier;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import javax.swing.Timer;

public class GraphPlane
extends JPanel
implements ActionListener {
    private Graphwar graphwar;
    private Image playerDefault;
    private Image helmetDefault;
    private Image helmetMaskDefault;
    private Image[][] playerAnimations;
    private int[][] playerDurations;
    private Image[] defaultImages;
    private Image[][][] animationImages;
    private Image[] deathImages;
    private int[] deathDurations;
    private int deathFadeDuration;
    private Image[] explosionImages;
    private int[] explosionDurations;
    private Image[] currentImages;
    private int[] currentDurations;
    private int totalCurrentMarkerDuration;
    private Image nextTeamImage;
    private BufferedImage functionImage;
    private Graphics2D functionGraphics;
    private int lastStepDrawn;
    private BufferedImage background;
    private Graphics2D backg;
    private boolean animating;
    private boolean repaintBack;
    private boolean nextMarker;
    private Timer timer;
    private static Color transparentWhite = new Color(255, 255, 255, 170);

    public GraphPlane(Graphwar graphwar) throws Exception {
        this.graphwar = graphwar;
        MediaTracker mediaTracker = new MediaTracker(graphwar);
        this.initializeExplosions(graphwar, mediaTracker);
        this.initializeDeaths(graphwar, mediaTracker);
        this.initializePlayersAnimations(graphwar, mediaTracker);
        this.initializeCurrentMarker(graphwar, mediaTracker);
        this.initializeNextTeamMarker(graphwar, mediaTracker);
        mediaTracker.waitForAll();
        this.animating = false;
        this.lastStepDrawn = 0;
        this.repaintBack = true;
        this.nextMarker = false;
        this.background = new BufferedImage(770, 450, 5);
        this.backg = this.background.createGraphics();
        this.backg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.timer = new Timer(30, this);
        this.timer.setInitialDelay(30);
    }

    private void initializeNextTeamMarker(Graphwar graphwar, MediaTracker mediaTracker) throws Exception {
        this.nextTeamImage = ImageIO.read(graphwar.getClass().getResource("/rsc/soldiers/nextTeam.png"));
        mediaTracker.addImage(this.nextTeamImage, 0);
    }

    private void initializeCurrentMarker(Graphwar graphwar, MediaTracker mediaTracker) throws Exception {
        String string = "/rsc/currentPlayerMarker.txt";
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(graphwar.getClass().getResourceAsStream(string)));
        int n = Integer.parseInt(GraphUtil.nextLine(bufferedReader).trim());
        this.currentImages = new Image[n];
        this.currentDurations = new int[n];
        this.totalCurrentMarkerDuration = 0;
        for (int i = 0; i < n; ++i) {
            this.currentImages[i] = ImageIO.read(graphwar.getClass().getResource(GraphUtil.nextLine(bufferedReader)));
            this.currentDurations[i] = Integer.parseInt(GraphUtil.nextLine(bufferedReader).trim());
            this.totalCurrentMarkerDuration += this.currentDurations[i];
            mediaTracker.addImage(this.currentImages[i], 0);
        }
    }

    private void initializeDeaths(Graphwar graphwar, MediaTracker mediaTracker) throws Exception {
        String string = "/rsc/soldierDeath.txt";
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(graphwar.getClass().getResourceAsStream(string)));
        int n = Integer.parseInt(GraphUtil.nextLine(bufferedReader).trim());
        this.deathImages = new Image[n];
        this.deathDurations = new int[n];
        for (int i = 0; i < n; ++i) {
            this.deathImages[i] = ImageIO.read(graphwar.getClass().getResource(GraphUtil.nextLine(bufferedReader)));
            this.deathDurations[i] = Integer.parseInt(GraphUtil.nextLine(bufferedReader).trim());
            mediaTracker.addImage(this.deathImages[i], 0);
        }
        this.deathFadeDuration = Integer.parseInt(GraphUtil.nextLine(bufferedReader).trim());
    }

    private void initializePlayersAnimations(Graphwar graphwar, MediaTracker mediaTracker) throws Exception {
        String string = "/rsc/soldier.txt";
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(graphwar.getClass().getResourceAsStream(string)));
        this.playerDefault = ImageIO.read(graphwar.getClass().getResource(GraphUtil.nextLine(bufferedReader)));
        mediaTracker.addImage(this.playerDefault, 0);
        this.helmetDefault = ImageIO.read(graphwar.getClass().getResource(GraphUtil.nextLine(bufferedReader)));
        mediaTracker.addImage(this.helmetDefault, 0);
        this.helmetMaskDefault = ImageIO.read(graphwar.getClass().getResource(GraphUtil.nextLine(bufferedReader)));
        mediaTracker.addImage(this.helmetMaskDefault, 0);
        int n = Integer.parseInt(GraphUtil.nextLine(bufferedReader).trim());
        this.playerAnimations = new Image[n][];
        this.playerDurations = new int[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = Integer.parseInt(GraphUtil.nextLine(bufferedReader).trim());
            this.playerAnimations[i] = new Image[n2];
            this.playerDurations[i] = new int[n2];
            for (int j = 0; j < n2; ++j) {
                this.playerAnimations[i][j] = ImageIO.read(graphwar.getClass().getResource(GraphUtil.nextLine(bufferedReader)));
                this.playerDurations[i][j] = Integer.parseInt(GraphUtil.nextLine(bufferedReader).trim());
                mediaTracker.addImage(this.playerAnimations[i][j], 0);
            }
        }
    }

    private void initializeExplosions(Graphwar graphwar, MediaTracker mediaTracker) throws Exception {
        String string = "/rsc/explosion.txt";
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(graphwar.getClass().getResourceAsStream(string)));
        int n = Integer.parseInt(GraphUtil.nextLine(bufferedReader).trim());
        this.explosionImages = new Image[n];
        this.explosionDurations = new int[n];
        for (int i = 0; i < n; ++i) {
            this.explosionImages[i] = ImageIO.read(graphwar.getClass().getResource(GraphUtil.nextLine(bufferedReader)));
            this.explosionDurations[i] = Integer.parseInt(GraphUtil.nextLine(bufferedReader).trim());
            mediaTracker.addImage(this.explosionImages[i], 0);
        }
    }

    public void setNextMarker(boolean bl) {
        this.nextMarker = bl;
        this.repaintBack = true;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        boolean bl = this.graphwar.getGameData().isTerrainReversed();
        if (this.repaintBack) {
            this.drawBackground(this.backg, bl);
            this.drawPlayersNames(this.backg, bl);
            this.drawCurrentPlayerMarker(this.backg, bl);
            if (this.nextMarker) {
                this.drawNextPlayersMarkers(this.backg, bl);
            }
            this.repaintBack = false;
        }
        graphics.drawImage(this.background, 0, 0, null);
        this.drawSoldiers(graphics, bl);
        this.drawFunction(graphics, bl);
        this.drawExplosion(graphics, bl);
    }

    private void drawBackground(Graphics2D graphics2D, boolean bl) {
        if (bl) {
            graphics2D.drawImage(this.graphwar.getGameData().getObstacle().getImage(), 0, 0, 770, 450, 770, 0, 0, 450, null);
        } else {
            graphics2D.drawImage(this.graphwar.getGameData().getObstacle().getImage(), 0, 0, null);
        }
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawLine(0, 225, 770, 225);
        graphics2D.drawLine(385, 0, 385, 450);
    }

    public void startDrawingFunction() {
        this.functionImage = new BufferedImage(770, 450, 6);
        this.functionGraphics = this.functionImage.createGraphics();
        this.functionGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.lastStepDrawn = 0;
    }

    private double convertX(double d) {
        return 770.0 * d / 50.0 + 385.0;
    }

    private double convertY(double d) {
        return -770.0 * d / 50.0 + 225.0;
    }

    private void drawFunctionImage(Graphics graphics, boolean bl) {
        int n = this.graphwar.getGameData().getCurrentFunctionPosition();
        GeneralPath generalPath = new GeneralPath();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color color = this.graphwar.getGameData().getCurrentTurnPlayer().getColor();
        graphics2D.setColor(color);
        Function function = this.graphwar.getGameData().getFunction();
        double d = this.convertX(function.getX(this.lastStepDrawn));
        double d2 = this.convertY(function.getY(this.lastStepDrawn));
        if (bl) {
            d = 770.0 - d;
        }
        generalPath.moveTo(d, d2);
        for (int i = this.lastStepDrawn; i < n; ++i) {
            d = this.convertX(function.getX(i));
            d2 = this.convertY(function.getY(i));
            if (bl) {
                d = 770.0 - d;
            }
            generalPath.lineTo(d, d2);
        }
        this.lastStepDrawn = n - 1;
        if (this.lastStepDrawn < 0) {
            this.lastStepDrawn = 0;
        }
        graphics2D.draw(generalPath);
    }

    private void drawFunction(Graphics graphics, boolean bl) {
        if (this.graphwar.getGameData().isDrawingFunction()) {
            boolean bl2 = this.graphwar.getGameData().isFunctionReversed();
            this.drawFunctionImage(this.functionGraphics, !(!bl2 && !bl || bl2 && bl));
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.graphwar.getGameData().isExploding()) {
                float f = 1.0f - (float)this.graphwar.getGameData().getTimeExploding() / 1000.0f;
                if (f < 0.0f) {
                    f = 0.0f;
                }
                graphics2D.setComposite(AlphaComposite.getInstance(3, f));
            }
            graphics2D.drawImage((Image)this.functionImage, 0, 0, null);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            this.repaintBack = true;
        }
    }

    private void drawExplosion(Graphics graphics, boolean bl) {
        if (this.graphwar.getGameData().isExploding()) {
            this.repaintBack = true;
            long l = this.graphwar.getGameData().getTimeExploding();
            Function function = this.graphwar.getGameData().getFunction();
            int n = this.explosionImages[0].getWidth(null);
            int n2 = this.explosionImages[0].getHeight(null);
            int n3 = (int)function.getLastX();
            int n4 = (int)(function.getLastY() - (double)(n2 / 2));
            boolean bl2 = this.graphwar.getGameData().isFunctionReversed();
            if (!(!bl2 && !bl || bl2 && bl)) {
                n3 = 770 - n3;
            }
            n3 -= n / 2;
            for (int i = 0; i < this.explosionDurations.length; ++i) {
                if (l > (long)this.explosionDurations[i]) {
                    l -= (long)this.explosionDurations[i];
                    continue;
                }
                graphics.drawImage(this.explosionImages[i], n3, n4, null);
                return;
            }
        }
    }

    private Image getSoldierImage(Soldier soldier, int n) {
        if (soldier.isExploding()) {
            long l = soldier.getTimeExploding();
            for (int i = 0; i < this.deathImages.length; ++i) {
                if (l > (long)this.deathDurations[i]) {
                    l -= (long)this.deathDurations[i];
                    continue;
                }
                this.repaintBack = true;
                return this.deathImages[i];
            }
            if (l < (long)this.deathFadeDuration) {
                BufferedImage bufferedImage = new BufferedImage(this.deathImages[this.deathImages.length - 1].getWidth(null), this.deathImages[this.deathImages.length - 1].getHeight(null), 6);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                float f = 1.0f - (float)l / (float)this.deathFadeDuration;
                if (f < 0.0f) {
                    f = 0.0f;
                }
                graphics2D.setComposite(AlphaComposite.getInstance(3, f));
                graphics2D.drawImage(this.deathImages[this.deathImages.length - 1], 0, 0, null);
                this.repaintBack = true;
                return bufferedImage;
            }
            return null;
        }
        if (soldier.isAnimating()) {
            int n2 = soldier.getAnimationNum() % this.playerAnimations.length;
            long l = soldier.getAnimationTime();
            for (int i = 0; i < this.playerAnimations[n2].length; ++i) {
                if (l > (long)this.playerDurations[n2][i]) {
                    l -= (long)this.playerDurations[n2][i];
                    continue;
                }
                return this.animationImages[n][n2][i];
            }
            soldier.endAnimation();
        }
        return this.defaultImages[n];
    }

    private Image addHelmet(Image image, Color color) {
        BufferedImage bufferedImage = new BufferedImage(20, 20, 6);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        BufferedImage bufferedImage2 = new BufferedImage(20, 20, 6);
        Graphics2D graphics2D2 = bufferedImage2.createGraphics();
        graphics2D2.drawImage(this.helmetMaskDefault, 0, 0, null);
        graphics2D2.setComposite(AlphaComposite.getInstance(5));
        graphics2D2.setColor(color);
        graphics2D2.fillRect(0, 0, 20, 20);
        graphics2D2.setComposite(AlphaComposite.getInstance(3));
        graphics2D2.drawImage(this.helmetDefault, 0, 0, null);
        graphics2D.drawImage((Image)bufferedImage2, 0, 0, null);
        return bufferedImage;
    }

    private void drawNextPlayersMarkers(Graphics graphics, boolean bl) {
        List<Player> list = this.graphwar.getGameData().getPlayers();
        for (Player player : list) {
            Soldier soldier;
            if (this.graphwar.getGameData().getCurrentTurnPlayer() == player || (soldier = player.getNextTurnSoldier()) == null) continue;
            int n = this.nextTeamImage.getWidth(null);
            int n2 = this.nextTeamImage.getHeight(null);
            int n3 = soldier.getX();
            int n4 = soldier.getY();
            if (bl) {
                n3 = 770 - n3;
            }
            graphics.drawImage(this.nextTeamImage, n3 - n / 2, n4 - n2 / 2, null);
        }
    }

    private void drawCurrentPlayerMarker(Graphics graphics, boolean bl) {
        int n;
        Player player = this.graphwar.getGameData().getCurrentTurnPlayer();
        Soldier[] soldierArray = player.getSoldiers();
        int n2 = player.getCurrentTurnSoldierIndex();
        long l = System.currentTimeMillis() % (long)this.totalCurrentMarkerDuration;
        int n3 = 0;
        for (n = 0; n < this.currentDurations.length; ++n) {
            if (l > (long)this.currentDurations[n]) {
                l -= (long)this.currentDurations[n];
                continue;
            }
            n3 = n;
            break;
        }
        n = this.currentImages[n3].getWidth(null);
        int n4 = this.currentImages[n3].getHeight(null);
        int n5 = soldierArray[n2].getX();
        int n6 = soldierArray[n2].getY();
        if (bl) {
            n5 = 770 - n5;
        }
        graphics.drawImage(this.currentImages[n3], n5 - n / 2, n6 - n4 / 2, null);
    }

    private void drawSoldiers(Graphics graphics, boolean bl) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        List<Player> list = this.graphwar.getGameData().getPlayers();
        Iterator<Player> iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Player player = iterator.next();
            Soldier[] soldierArray = player.getSoldiers();
            int n2 = player.getNumSoldiers();
            for (int i = 0; i < n2; ++i) {
                Image image;
                if (!soldierArray[i].isAlive() && !soldierArray[i].isExploding()) continue;
                int n3 = soldierArray[i].getX();
                int n4 = soldierArray[i].getY();
                if (bl) {
                    n3 = 770 - n3;
                }
                if ((image = this.getSoldierImage(soldierArray[i], n)) == null) continue;
                int n5 = image.getWidth(null);
                int n6 = image.getHeight(null);
                graphics.drawImage(this.background, n3 - n5 / 2, n4 - n6 / 2, n3 + n5 / 2, n4 + n6 / 2, n3 - n5 / 2, n4 - n6 / 2, n3 + n5 / 2, n4 + n6 / 2, null);
                if (!(player.getTeam() != 2 && !bl || player.getTeam() == 2 && bl)) {
                    graphics2D.drawImage(image, n3 - n5 / 2, n4 - n6 / 2, n3 + n5 / 2, n4 + n6 / 2, n5, 0, 0, n6, null);
                    continue;
                }
                graphics2D.drawImage(image, n3 - n5 / 2, n4 - n6 / 2, null);
            }
            ++n;
        }
    }

    private void paintPlayerName(Graphics graphics, int n, int n2, Player player) {
        int n3 = 3;
        int n4 = player.getNameLength();
        int n5 = n - n4 / 2 - n3;
        int n6 = n2 - 15 - 14;
        int n7 = n - n4 / 2;
        int n8 = n2 - 2 - 14;
        if (n6 < 0) {
            n6 = n2 - 2 + 14;
            n8 = n2 + 11 + 14;
        }
        if (n5 < 0) {
            n7 -= n5;
            n5 = 0;
        }
        if (n5 + n4 + 2 * n3 > 770) {
            n7 = n7 - n5 + 770 - n4 - 2 * n3;
            n5 = 770 - n4 - 2 * n3;
        }
        graphics.setColor(transparentWhite);
        graphics.fillRoundRect(n5, n6, n4 + 2 * n3, 15, 7, 7);
        graphics.setColor(player.getColor());
        graphics.drawRoundRect(n5, n6, n4 + 2 * n3, 15, 7, 7);
        graphics.setColor(Color.BLACK);
        graphics.drawString(player.getName(), n7, n8);
    }

    private void drawPlayersNames(Graphics graphics, boolean bl) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setFont(Constants.NAME_FONT);
        List<Player> list = this.graphwar.getGameData().getPlayers();
        for (Player player : list) {
            Soldier[] soldierArray = player.getSoldiers();
            graphics2D.setColor(player.getColor());
            for (int i = 0; i < player.getNumSoldiers(); ++i) {
                int n = soldierArray[i].getX();
                int n2 = soldierArray[i].getY();
                if (bl) {
                    n = 770 - soldierArray[i].getX();
                }
                if (soldierArray[i].isAlive()) {
                    this.paintPlayerName(graphics2D, n, n2, player);
                    continue;
                }
                if (!soldierArray[i].isExploding()) continue;
                float f = 1.0f - (float)soldierArray[i].getTimeExploding() / 1000.0f;
                if (f < 0.0f) {
                    f = 0.0f;
                }
                graphics2D.setComposite(AlphaComposite.getInstance(3, f));
                this.paintPlayerName(graphics2D, n, n2, player);
                graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            }
        }
    }

    private void initializeImages() {
        int n;
        int n2;
        List<Player> list = this.graphwar.getGameData().getPlayers();
        this.defaultImages = new Image[list.size()];
        this.animationImages = new Image[list.size()][this.playerAnimations.length][];
        for (n2 = 0; n2 < this.animationImages.length; ++n2) {
            for (n = 0; n < this.playerAnimations.length; ++n) {
                this.animationImages[n2][n] = new Image[this.playerAnimations[n].length];
            }
        }
        for (n2 = 0; n2 < this.defaultImages.length; ++n2) {
            this.defaultImages[n2] = this.addHelmet(this.playerDefault, list.get(n2).getColor());
        }
        for (n2 = 0; n2 < this.animationImages.length; ++n2) {
            for (n = 0; n < this.animationImages[n2].length; ++n) {
                for (int i = 0; i < this.animationImages[n2][n].length; ++i) {
                    this.animationImages[n2][n][i] = this.addHelmet(this.playerAnimations[n][i], list.get(n2).getColor());
                }
            }
        }
    }

    public void refreshBackground() {
        this.repaintBack = true;
    }

    public void refreshSoldiers() {
        this.initializeImages();
    }

    public void startAnimating() {
        if (!this.animating) {
            this.initializeImages();
            this.animating = true;
            this.timer.start();
        }
    }

    public void stopAnimating() {
        this.animating = false;
        this.timer.stop();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (((GameScreen)this.graphwar.getUI().getScreen(3)).isQuitVisible() || ((GameScreen)this.graphwar.getUI().getScreen(3)).isShowMessageVisible()) {
            this.repaintBack = true;
            this.getParent().repaint();
        } else {
            this.repaint();
        }
    }
}

