/*
 * Decompiled with CFR 0.152.
 */
package Graphwar;

import java.awt.Color;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class GraphTextBox
extends JScrollPane {
    private JTextPane textPane = new JTextPane();
    private StyledDocument text;
    private Style nameStyle;
    private Style messageStyle;
    private Style systemStyle;

    public GraphTextBox() {
        this.textPane.setEditable(false);
        this.text = (StyledDocument)this.textPane.getDocument();
        this.nameStyle = this.text.addStyle("nameStyle", null);
        this.messageStyle = this.text.addStyle("messageStyle", null);
        this.systemStyle = this.text.addStyle("systemStyle", null);
        StyleConstants.setForeground(this.systemStyle, new Color(160, 160, 160));
        StyleConstants.setItalic(this.systemStyle, true);
        this.setViewportView(this.textPane);
        this.setVerticalScrollBarPolicy(22);
        this.setHorizontalScrollBarPolicy(31);
    }

    public void addText(final String string, final Color color, final String string2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean bl;
                boolean bl2 = bl = GraphTextBox.this.getVerticalScrollBar().getMaximum() - (GraphTextBox.this.getVerticalScrollBar().getValue() + GraphTextBox.this.getVerticalScrollBar().getVisibleAmount()) < 20;
                if (string == null) {
                    try {
                        GraphTextBox.this.text.insertString(GraphTextBox.this.text.getLength(), string2 + "\n", GraphTextBox.this.systemStyle);
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                } else {
                    StyleConstants.setForeground(GraphTextBox.this.nameStyle, color);
                    StyleConstants.setBold(GraphTextBox.this.nameStyle, true);
                    try {
                        GraphTextBox.this.text.insertString(GraphTextBox.this.text.getLength(), string + ": ", GraphTextBox.this.nameStyle);
                        GraphTextBox.this.text.insertString(GraphTextBox.this.text.getLength(), string2 + "\n", GraphTextBox.this.messageStyle);
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                }
                if (bl) {
                    GraphTextBox.this.textPane.setCaretPosition(GraphTextBox.this.text.getLength());
                }
                GraphTextBox.this.revalidate();
            }
        });
    }

    public void emptyText() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    GraphTextBox.this.text.remove(0, GraphTextBox.this.text.getLength());
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        });
    }
}

