/*
 * Decompiled with CFR 0.152.
 */
package Graphwar;

import Graphwar.Graphwar;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.Timer;

public class GraphTimer
extends JPanel
implements ActionListener {
    private boolean running = false;
    private Graphwar graphwar;
    private Timer timer;
    private static Font font = new Font("Sans", 1, 18);

    public GraphTimer(Graphwar graphwar) {
        this.graphwar = graphwar;
        this.timer = new Timer(50, this);
        this.timer.setInitialDelay(50);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics2D.setFont(font);
        graphics2D.setColor(Color.BLACK);
        long l = this.graphwar.getGameData().getRemainingTime();
        double d = l /= 100L;
        d /= 10.0;
        if (d < 0.0) {
            d = 0.0;
        }
        if (l < 50L) {
            graphics2D.setColor(Color.RED);
        }
        graphics2D.drawString(Double.toString(d), 4, 19);
    }

    public void startRunning() {
        if (!this.running) {
            this.running = true;
            this.timer.start();
        }
    }

    public void stopRunning() {
        this.running = false;
        this.timer.stop();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.repaint();
    }
}

