/*
 * Decompiled with CFR 0.152.
 */
package Graphwar;

import Graphwar.GameScreen;
import Graphwar.GlobalScreen;
import Graphwar.Graphwar;
import Graphwar.MainMenuScreen;
import Graphwar.PreGameScreen;
import Graphwar.StartStopPanel;
import javax.swing.JPanel;

public class GraphUI
extends JPanel {
    private JPanel[] screens;
    private JPanel currentScreen;
    private int currentScreenIndex;
    private Graphwar graphwar;

    public GraphUI(Graphwar graphwar) throws Exception {
        this.graphwar = graphwar;
        this.setLayout(null);
        this.screens = new JPanel[4];
        this.screens[0] = new MainMenuScreen(graphwar, "/rsc/MainMenu.txt");
        this.screens[1] = new PreGameScreen(graphwar, "/rsc/PreGame.txt");
        this.screens[2] = new GlobalScreen(graphwar, "/rsc/GlobalRoom.txt");
        this.screens[3] = new GameScreen(graphwar, "/rsc/GameScreen.txt");
        this.currentScreenIndex = -1;
        this.currentScreen = null;
    }

    public void stop() {
        for (int i = 0; i < this.screens.length; ++i) {
            if (!(this.screens[i] instanceof StartStopPanel)) continue;
            ((StartStopPanel)((Object)this.screens[i])).stopPanel();
        }
    }

    public void setScreen(int n) {
        if (this.currentScreenIndex != n) {
            if (this.currentScreen instanceof StartStopPanel) {
                ((StartStopPanel)((Object)this.currentScreen)).stopPanel();
            }
            this.removeAll();
            this.add(this.screens[n]);
            this.revalidate();
            this.repaint();
            this.currentScreen = this.screens[n];
            this.currentScreenIndex = n;
            if (this.currentScreen instanceof StartStopPanel) {
                ((StartStopPanel)((Object)this.currentScreen)).startPanel();
            }
        }
    }

    public JPanel getScreen(int n) {
        return this.screens[n];
    }
}

