/*
 * Decompiled with CFR 0.152.
 */
package Graphwar;

import GraphServer.Constants;
import GraphServer.GraphServer;
import Graphwar.GameData;
import Graphwar.GlobalClient;
import Graphwar.GraphUI;
import java.awt.Dimension;
import java.io.IOException;
import javax.swing.JFrame;

public class Graphwar
extends JFrame {
    private GraphServer gameServer;
    private GameData gameData;
    private GlobalClient globalClient;
    private GraphUI graphUI;

    public static void main(String[] stringArray) {
        Graphwar.handleArgs(stringArray);
        Graphwar graphwar = new Graphwar();
        graphwar.init();
        while (true) {
            try {
                while (true) {
                    Thread.sleep(10000L);
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static void handleArgs(String[] stringArray) {
        if (stringArray.length > 0) {
            Constants.GLOBAL_IP = stringArray[0];
        }
    }

    public void init() {
        this.setTitle("Graphwar");
        this.setDefaultCloseOperation(3);
        this.getContentPane().setPreferredSize(new Dimension(800, 600));
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.setResizable(false);
        try {
            this.gameData = new GameData(this);
            this.globalClient = new GlobalClient(this);
            this.graphUI = new GraphUI(this);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.add(this.graphUI);
        this.graphUI.setScreen(0);
        this.validate();
        this.repaint();
    }

    public void start() {
    }

    public void stop() {
        this.globalClient.stop();
        this.gameData.disconnect();
        this.graphUI.stop();
        if (this.gameServer != null) {
            this.gameServer.finalize();
            this.gameServer = null;
        }
    }

    public void destroy() {
    }

    public GraphUI getUI() {
        return this.graphUI;
    }

    public GameData getGameData() {
        return this.gameData;
    }

    public GlobalClient getGlobalClient() {
        return this.globalClient;
    }

    public void finishGame() {
        if (this.gameServer != null) {
            this.gameServer.finalize();
            this.gameServer = null;
        }
    }

    public void joinGlobal(String string) throws IOException {
        this.globalClient.joinGlobalServer(Constants.GLOBAL_IP, 23761, string);
        this.graphUI.setScreen(2);
    }

    public void joinGame(String string, int n) throws IOException {
        this.gameData.connect(string, n);
    }

    public void createGame(int n) throws IOException {
        this.gameServer = new GraphServer(n);
        new Thread(this.gameServer).start();
        this.gameData.connect("localhost", n);
        this.graphUI.setScreen(1);
    }
}

