/*
 * Decompiled with CFR 0.152.
 */
package Graphwar;

import GraphServer.Constants;
import Graphwar.GraphButton;
import Graphwar.GraphUtil;
import Graphwar.Graphwar;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Stack;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class MainMenuScreen
extends JPanel
implements ActionListener {
    private Graphwar graphwar;
    private JLabel[] backgroundImages;
    private GraphButton joinGlobal;
    private GraphButton createGame;
    private GraphButton joinGame;
    private String message;
    private int messageX;
    private boolean showMessage;
    private JLabel[] backgroundsGlobal;
    private JTextField nameFieldGlobal;
    private GraphButton yesButtonGlobal;
    private GraphButton noButtonGlobal;
    private boolean joinGlobalVisible;
    private JLabel[] backgroundsCreate;
    private JTextField nameFieldCreate;
    private JTextField portFieldCreate;
    private GraphButton yesButtonCreate;
    private GraphButton noButtonCreate;
    private boolean createVisible;
    private JLabel[] backgroundsJoin;
    private JTextField nameFieldJoin;
    private JTextField portFieldJoin;
    private JTextField ipFieldJoin;
    private GraphButton yesButtonJoin;
    private GraphButton noButtonJoin;
    private boolean joinVisible;
    private static Font font = new Font("Sans", 1, 12);

    public MainMenuScreen(Graphwar graphwar, String string) throws InterruptedException, IOException {
        int n;
        this.graphwar = graphwar;
        this.setLayout(null);
        this.setBounds(0, 0, 800, 600);
        InputStreamReader inputStreamReader = new InputStreamReader(graphwar.getClass().getResourceAsStream(string));
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        Stack<Component> stack = new Stack<Component>();
        int n2 = Integer.parseInt(GraphUtil.nextLine(bufferedReader));
        this.backgroundImages = new JLabel[n2];
        for (n = 0; n < n2; ++n) {
            this.backgroundImages[n] = GraphUtil.makeBackgroundImage(graphwar, bufferedReader);
            stack.push(this.backgroundImages[n]);
        }
        this.joinGlobal = GraphUtil.makeButton(graphwar, bufferedReader);
        this.createGame = GraphUtil.makeButton(graphwar, bufferedReader);
        this.joinGame = GraphUtil.makeButton(graphwar, bufferedReader);
        stack.push(this.joinGlobal);
        stack.push(this.createGame);
        stack.push(this.joinGame);
        this.joinGlobal.addActionListener(this);
        this.createGame.addActionListener(this);
        this.joinGame.addActionListener(this);
        n2 = Integer.parseInt(GraphUtil.nextLine(bufferedReader));
        this.backgroundsGlobal = new JLabel[n2];
        for (n = 0; n < n2; ++n) {
            this.backgroundsGlobal[n] = GraphUtil.makeBackgroundImage(graphwar, bufferedReader);
            stack.push(this.backgroundsGlobal[n]);
        }
        this.nameFieldGlobal = GraphUtil.makeTextField(bufferedReader);
        this.yesButtonGlobal = GraphUtil.makeButton(graphwar, bufferedReader);
        this.noButtonGlobal = GraphUtil.makeButton(graphwar, bufferedReader);
        stack.push(this.nameFieldGlobal);
        stack.push(this.yesButtonGlobal);
        stack.push(this.noButtonGlobal);
        this.showJoinGlobal(false);
        this.nameFieldGlobal.addActionListener(this);
        this.yesButtonGlobal.addActionListener(this);
        this.noButtonGlobal.addActionListener(this);
        n2 = Integer.parseInt(GraphUtil.nextLine(bufferedReader));
        this.backgroundsCreate = new JLabel[n2];
        for (n = 0; n < n2; ++n) {
            this.backgroundsCreate[n] = GraphUtil.makeBackgroundImage(graphwar, bufferedReader);
            stack.push(this.backgroundsCreate[n]);
        }
        this.nameFieldCreate = GraphUtil.makeTextField(bufferedReader);
        this.portFieldCreate = GraphUtil.makeTextField(bufferedReader);
        this.yesButtonCreate = GraphUtil.makeButton(graphwar, bufferedReader);
        this.noButtonCreate = GraphUtil.makeButton(graphwar, bufferedReader);
        stack.push(this.nameFieldCreate);
        stack.push(this.portFieldCreate);
        stack.push(this.yesButtonCreate);
        stack.push(this.noButtonCreate);
        this.showCreateGame(false);
        this.nameFieldCreate.addActionListener(this);
        this.portFieldCreate.addActionListener(this);
        this.yesButtonCreate.addActionListener(this);
        this.noButtonCreate.addActionListener(this);
        n2 = Integer.parseInt(GraphUtil.nextLine(bufferedReader));
        this.backgroundsJoin = new JLabel[n2];
        for (n = 0; n < n2; ++n) {
            this.backgroundsJoin[n] = GraphUtil.makeBackgroundImage(graphwar, bufferedReader);
            stack.push(this.backgroundsJoin[n]);
        }
        this.nameFieldJoin = GraphUtil.makeTextField(bufferedReader);
        this.portFieldJoin = GraphUtil.makeTextField(bufferedReader);
        this.ipFieldJoin = GraphUtil.makeTextField(bufferedReader);
        stack.push(this.nameFieldJoin);
        stack.push(this.portFieldJoin);
        stack.push(this.ipFieldJoin);
        this.yesButtonJoin = GraphUtil.makeButton(graphwar, bufferedReader);
        this.noButtonJoin = GraphUtil.makeButton(graphwar, bufferedReader);
        stack.push(this.yesButtonJoin);
        stack.push(this.noButtonJoin);
        this.showJoinGame(false);
        this.nameFieldJoin.addActionListener(this);
        this.portFieldJoin.addActionListener(this);
        this.ipFieldJoin.addActionListener(this);
        this.yesButtonJoin.addActionListener(this);
        this.noButtonJoin.addActionListener(this);
        this.addComponentsReversed(this, stack);
        this.revalidate();
    }

    private void addComponentsReversed(JPanel jPanel, Stack<Component> stack) {
        while (!stack.empty()) {
            jPanel.add(stack.pop());
        }
    }

    private void showJoinGame(boolean bl) {
        final boolean bl2 = bl;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainMenuScreen.this.nameFieldJoin.setVisible(bl2);
                MainMenuScreen.this.portFieldJoin.setVisible(bl2);
                MainMenuScreen.this.ipFieldJoin.setVisible(bl2);
                MainMenuScreen.this.yesButtonJoin.setVisible(bl2);
                MainMenuScreen.this.noButtonJoin.setVisible(bl2);
                MainMenuScreen.this.joinVisible = bl2;
                for (int i = 0; i < MainMenuScreen.this.backgroundsJoin.length; ++i) {
                    MainMenuScreen.this.backgroundsJoin[i].setVisible(bl2);
                }
                MainMenuScreen.this.portFieldJoin.setText("6112");
            }
        });
    }

    private void showCreateGame(boolean bl) {
        final boolean bl2 = bl;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainMenuScreen.this.nameFieldCreate.setVisible(bl2);
                MainMenuScreen.this.portFieldCreate.setVisible(bl2);
                MainMenuScreen.this.yesButtonCreate.setVisible(bl2);
                MainMenuScreen.this.noButtonCreate.setVisible(bl2);
                MainMenuScreen.this.createVisible = bl2;
                for (int i = 0; i < MainMenuScreen.this.backgroundsCreate.length; ++i) {
                    MainMenuScreen.this.backgroundsCreate[i].setVisible(bl2);
                }
                MainMenuScreen.this.portFieldCreate.setText("6112");
            }
        });
    }

    private void showJoinGlobal(boolean bl) {
        final boolean bl2 = bl;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainMenuScreen.this.nameFieldGlobal.setVisible(bl2);
                MainMenuScreen.this.yesButtonGlobal.setVisible(bl2);
                MainMenuScreen.this.noButtonGlobal.setVisible(bl2);
                MainMenuScreen.this.joinGlobalVisible = bl2;
                for (int i = 0; i < MainMenuScreen.this.backgroundsGlobal.length; ++i) {
                    MainMenuScreen.this.backgroundsGlobal[i].setVisible(bl2);
                }
            }
        });
    }

    public void showMessage(String string) {
        this.showMessage = true;
        this.message = string;
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(Constants.NAME_FONT);
        int n = fontMetrics.stringWidth(string);
        this.messageX = (800 - n) / 2;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        graphics.setColor(Constants.BACKGROUND);
        graphics.fillRect(0, 0, 800, 600);
        this.paintMessage(graphics);
    }

    public void paintMessage(Graphics graphics) {
        if (this.showMessage) {
            graphics.setFont(font);
            graphics.setColor(Color.red);
            graphics.drawString(this.message, this.messageX, 15);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block34: {
            if (this.joinGlobalVisible) {
                String string;
                if (actionEvent.getSource() == this.noButtonGlobal) {
                    this.showJoinGlobal(false);
                    this.showMessage = false;
                    this.repaint();
                } else if ((actionEvent.getSource() == this.yesButtonGlobal || actionEvent.getSource() == this.nameFieldGlobal) && (string = this.nameFieldGlobal.getText()) != null && string.length() > 0) {
                    if (string.length() > 20) {
                        this.nameFieldGlobal.setText(string.substring(0, 20));
                    } else {
                        this.showMessage("Connecting...");
                        try {
                            this.graphwar.joinGlobal(string);
                            this.showJoinGlobal(false);
                            this.showMessage = false;
                        }
                        catch (IOException iOException) {
                            this.showMessage("Could not connect.");
                            iOException.printStackTrace();
                        }
                    }
                }
            } else if (this.createVisible) {
                if (actionEvent.getSource() == this.noButtonCreate) {
                    this.showCreateGame(false);
                    this.showMessage = false;
                    this.repaint();
                } else if (actionEvent.getSource() == this.yesButtonCreate || actionEvent.getSource() == this.nameFieldCreate || actionEvent.getSource() == this.portFieldCreate) {
                    try {
                        String string = this.nameFieldCreate.getText();
                        int n = Integer.parseInt(this.portFieldCreate.getText());
                        if (string == null || string.length() == 0) break block34;
                        if (string.length() > 20) {
                            this.nameFieldCreate.setText(string.substring(0, 20));
                            break block34;
                        }
                        this.showMessage("Creating...");
                        try {
                            this.graphwar.createGame(n);
                            this.graphwar.getGameData().addPlayer(string);
                            this.showCreateGame(false);
                            this.showMessage = false;
                        }
                        catch (IOException iOException) {
                            this.showMessage("Failed! Check if port is not already in use.");
                            iOException.printStackTrace();
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.showMessage("Port must be a number.");
                    }
                }
            } else if (this.joinVisible) {
                if (actionEvent.getSource() == this.noButtonJoin) {
                    this.showJoinGame(false);
                    this.showMessage = false;
                    this.repaint();
                } else if (actionEvent.getSource() == this.yesButtonJoin || actionEvent.getSource() == this.nameFieldJoin || actionEvent.getSource() == this.ipFieldJoin || actionEvent.getSource() == this.portFieldJoin) {
                    try {
                        String string = this.nameFieldJoin.getText();
                        String string2 = this.ipFieldJoin.getText();
                        int n = Integer.parseInt(this.portFieldJoin.getText());
                        if (string == null || string.length() <= 0 || string2 == null || string2.length() <= 0) break block34;
                        if (string.length() > 20) {
                            this.nameFieldJoin.setText(string.substring(0, 20));
                            break block34;
                        }
                        this.showMessage("Connecting...");
                        try {
                            this.graphwar.joinGame(string2, n);
                            this.graphwar.getGameData().addPlayer(string);
                            this.showJoinGame(false);
                            this.showMessage = false;
                            this.graphwar.getUI().setScreen(1);
                        }
                        catch (IOException iOException) {
                            this.showMessage("Could not connect.");
                            this.graphwar.getGameData().disconnect();
                            iOException.printStackTrace();
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.showMessage("Port must be a number.");
                    }
                }
            } else if (actionEvent.getSource() == this.joinGlobal) {
                this.showJoinGlobal(true);
                this.repaint();
            } else if (actionEvent.getSource() == this.createGame) {
                this.showCreateGame(true);
                this.repaint();
            } else if (actionEvent.getSource() == this.joinGame) {
                this.showJoinGame(true);
                this.repaint();
            }
        }
    }
}

