/*
 * Decompiled with CFR 0.152.
 */
package Graphwar;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Random;

public class Obstacle {
    private BufferedImage terrain = new BufferedImage(770, 450, 5);
    private Graphics2D terrainGraphics = (Graphics2D)this.terrain.getGraphics();
    int expX;
    int expY;
    int expRadius;

    Obstacle(int n, int[] nArray) {
        this.terrainGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.terrainGraphics.setColor(Color.WHITE);
        this.terrainGraphics.fillRect(0, 0, this.terrain.getWidth(), this.terrain.getHeight());
        this.terrainGraphics.setColor(Color.BLACK);
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[3 * i];
            int n3 = nArray[3 * i + 1];
            int n4 = nArray[3 * i + 2];
            this.terrainGraphics.fillOval(n2 - n4, n3 - n4, 2 * n4, 2 * n4);
        }
        this.terrainGraphics.setColor(Color.WHITE);
        this.expX = 0;
        this.expY = 0;
        this.expRadius = 0;
    }

    public static int getNumCircles() {
        Random random = new Random();
        int n = (int)(random.nextGaussian() * 7.0 + 15.0);
        while (n < 0) {
            n = (int)(random.nextGaussian() * 7.0 + 15.0);
        }
        return n;
    }

    public int getExplosionX() {
        return this.expX;
    }

    public int getExplosionY() {
        return this.expY;
    }

    public int getExplosionRadius() {
        return this.expRadius;
    }

    public boolean collidePoint(int n, int n2) {
        if (n < 0 || n >= 770) {
            return true;
        }
        if (n2 < 0 || n2 >= 450) {
            return true;
        }
        return this.terrain.getRGB(n, n2) != -1;
    }

    public void setExplosion(int n, int n2, int n3) {
        this.expX = n;
        this.expY = n2;
        this.expRadius = n3;
    }

    public void explodePoint() {
        this.terrainGraphics.fillOval(this.expX - this.expRadius, this.expY - this.expRadius, this.expRadius * 2, this.expRadius * 2);
    }

    public boolean soldierCollides(int n, int n2, int n3) {
        if (n + n3 >= 770) {
            return true;
        }
        if (n - n3 < 0) {
            return true;
        }
        if (n2 + n3 >= 450) {
            return true;
        }
        if (n2 - n3 < 0) {
            return true;
        }
        return this.terrain.getRGB(n, n2) != -1 || this.terrain.getRGB(n + n3, n2) != -1 || this.terrain.getRGB(n - n3, n2) != -1 || this.terrain.getRGB(n, n2 + n3) != -1 || this.terrain.getRGB(n, n2 - n3) != -1;
    }

    public Image getImage() {
        return this.terrain;
    }
}

