/*
 * Decompiled with CFR 0.152.
 */
package Graphwar;

import GraphServer.Constants;
import Graphwar.GraphUtil;
import Graphwar.Soldier;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Toolkit;

public class Player {
    private String name;
    protected int team;
    private int numSoldiers;
    protected Soldier[] soldiers;
    protected int currentTurnSoldier;
    private int playerID;
    private boolean localPlayer;
    private Color color;
    private boolean ready;
    private int nameLength;
    private boolean disconnected;

    public Player(String string, int n, int n2, boolean bl, int n3, boolean bl2) {
        this.name = string;
        this.team = n2;
        this.numSoldiers = n3;
        this.soldiers = new Soldier[4];
        for (int i = 0; i < this.soldiers.length; ++i) {
            this.soldiers[i] = new Soldier();
        }
        this.currentTurnSoldier = 0;
        this.localPlayer = bl;
        this.playerID = n;
        this.color = GraphUtil.getRandomColor();
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(Constants.NAME_FONT);
        this.nameLength = fontMetrics.stringWidth(string);
        this.disconnected = false;
    }

    public boolean isDisconnected() {
        return this.disconnected;
    }

    public void markDisconnected() {
        this.disconnected = true;
    }

    public int getNameLength() {
        return this.nameLength;
    }

    public boolean getReady() {
        return this.ready;
    }

    public void setReady(boolean bl) {
        this.ready = bl;
    }

    public String getName() {
        return this.name;
    }

    public void setTeam(int n) {
        this.team = n;
    }

    public int getTeam() {
        return this.team;
    }

    public void startSoldier(int n, int n2, int n3) {
        this.soldiers[n] = new Soldier(n2, n3);
    }

    public void setSoldiers(int n) {
        this.numSoldiers = n;
    }

    public int getNumSoldiers() {
        return this.numSoldiers;
    }

    public Soldier[] getSoldiers() {
        return this.soldiers;
    }

    public int getCurrentTurnSoldierIndex() {
        return this.currentTurnSoldier;
    }

    public Soldier getCurrentTurnSoldier() {
        return this.soldiers[this.currentTurnSoldier];
    }

    public int getID() {
        return this.playerID;
    }

    public boolean isLocalPlayer() {
        return this.localPlayer;
    }

    public Color getColor() {
        return this.color;
    }

    public void restartTurn() {
        this.currentTurnSoldier = 0;
    }

    public Soldier getNextTurnSoldier() {
        int n = this.currentTurnSoldier;
        for (int i = 0; i < this.numSoldiers; ++i) {
            if (!this.soldiers[n = (n + 1) % this.numSoldiers].isAlive()) continue;
            return this.soldiers[n];
        }
        return null;
    }

    public boolean nextTurn() {
        for (int i = 0; i < this.numSoldiers; ++i) {
            this.currentTurnSoldier = (this.currentTurnSoldier + 1) % this.numSoldiers;
            if (!this.soldiers[this.currentTurnSoldier].isAlive()) continue;
            return true;
        }
        return false;
    }
}

