/*
 * Decompiled with CFR 0.152.
 */
package Graphwar;

import Graphwar.GraphButton;
import Graphwar.GraphUtil;
import Graphwar.Graphwar;
import Graphwar.Player;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.ListIterator;
import javax.swing.JPanel;

public class PlayerBoard
extends JPanel {
    private Graphwar graphwar;
    private Image switchNormal;
    private Image switchOver;
    private Image switchGray;
    private BufferedImage switchMask;
    private Image switchNormalMirror;
    private Image switchOverMirror;
    private Image switchGrayMirror;
    private BufferedImage switchMaskMirror;
    private Image soldierNormal;
    private Image soldierOver;
    private Image soldierGhost;
    private BufferedImage soldierMask;
    private Image soldierNormalMirror;
    private Image soldierOverMirror;
    private Image soldierGhostMirror;
    private BufferedImage soldierMaskMirror;
    private Image removeNormal;
    private Image removeOver;
    private Image removeGray;
    private BufferedImage removeMask;
    private Image removeNormalMirror;
    private Image removeOverMirror;
    private Image removeGrayMirror;
    private BufferedImage removeMaskMirror;
    private int entryWidth;
    private int entryHeight;
    private int team2Offset;
    private PlayerEntry[] playersEntries;
    private int numPlayers;

    public PlayerBoard(Graphwar graphwar, int n, int n2, int n3, Image image, Image image2, Image image3, BufferedImage bufferedImage, Image image4, Image image5, Image image6, BufferedImage bufferedImage2, Image image7, Image image8, Image image9, BufferedImage bufferedImage3) {
        this.setLayout(null);
        this.graphwar = graphwar;
        this.playersEntries = new PlayerEntry[10];
        this.numPlayers = 0;
        this.switchNormal = image;
        this.switchOver = image2;
        this.switchGray = image3;
        this.switchMask = bufferedImage;
        this.soldierNormal = image4;
        this.soldierOver = image5;
        this.soldierGhost = image6;
        this.soldierMask = bufferedImage2;
        this.removeNormal = image7;
        this.removeOver = image8;
        this.removeGray = image9;
        this.removeMask = bufferedImage3;
        this.switchNormalMirror = GraphUtil.mirrorImage(image);
        this.switchOverMirror = GraphUtil.mirrorImage(image2);
        this.switchGrayMirror = GraphUtil.mirrorImage(image3);
        this.switchMaskMirror = GraphUtil.mirrorImage(bufferedImage);
        this.soldierNormalMirror = GraphUtil.mirrorImage(image4);
        this.soldierOverMirror = GraphUtil.mirrorImage(image5);
        this.soldierGhostMirror = GraphUtil.mirrorImage(image6);
        this.soldierMaskMirror = GraphUtil.mirrorImage(bufferedImage2);
        this.removeNormalMirror = GraphUtil.mirrorImage(image7);
        this.removeOverMirror = GraphUtil.mirrorImage(image8);
        this.removeGrayMirror = GraphUtil.mirrorImage(image9);
        this.removeMaskMirror = GraphUtil.mirrorImage(bufferedImage3);
        this.entryWidth = n;
        this.entryHeight = n2;
        this.team2Offset = n3;
        this.setOpaque(false);
    }

    private void updatePlayerButtons(Player player) {
        for (int i = 0; i < this.numPlayers; ++i) {
            if (this.playersEntries[i].player != player) continue;
            if (player.getTeam() == 1) {
                if (player.isLocalPlayer() || this.graphwar.getGameData().isLeader()) {
                    this.playersEntries[i].switchSide.updateImages(this.switchNormal, this.switchOver, this.switchMask);
                    this.playersEntries[i].removePlayer.updateImages(this.removeNormal, this.removeOver, this.removeMask);
                } else {
                    this.playersEntries[i].switchSide.updateImages(this.switchNormal, this.switchGray, this.switchMask);
                    this.playersEntries[i].removePlayer.updateImages(this.removeNormal, this.removeGray, this.removeMask);
                }
                for (int j = 0; j < this.playersEntries[i].addSoldier.length; ++j) {
                    if (j < this.playersEntries[i].player.getNumSoldiers()) {
                        this.playersEntries[i].addSoldier[j].updateImages(this.soldierNormal, this.soldierOver, this.soldierMask);
                        continue;
                    }
                    this.playersEntries[i].addSoldier[j].updateImages(this.soldierGhost, this.soldierOver, this.soldierMask);
                }
            } else {
                if (player.isLocalPlayer() || this.graphwar.getGameData().isLeader()) {
                    this.playersEntries[i].switchSide.updateImages(this.switchNormalMirror, this.switchOverMirror, this.switchMaskMirror);
                    this.playersEntries[i].removePlayer.updateImages(this.removeNormalMirror, this.removeOverMirror, this.removeMaskMirror);
                } else {
                    this.playersEntries[i].switchSide.updateImages(this.switchNormalMirror, this.switchGrayMirror, this.switchMaskMirror);
                    this.playersEntries[i].removePlayer.updateImages(this.removeNormalMirror, this.removeGrayMirror, this.removeMaskMirror);
                }
                for (int j = 0; j < this.playersEntries[i].addSoldier.length; ++j) {
                    if (j < this.playersEntries[i].player.getNumSoldiers()) {
                        this.playersEntries[i].addSoldier[j].updateImages(this.soldierNormalMirror, this.soldierOverMirror, this.soldierMaskMirror);
                        continue;
                    }
                    this.playersEntries[i].addSoldier[j].updateImages(this.soldierGhostMirror, this.soldierOverMirror, this.soldierMaskMirror);
                }
            }
            return;
        }
    }

    public void updateBoard() {
        this.removeAll();
        this.numPlayers = 0;
        ListIterator<Player> listIterator = this.graphwar.getGameData().getPlayers().listIterator();
        while (listIterator.hasNext()) {
            Player player = listIterator.next();
            this.addPlayer(player);
        }
        this.revalidate();
        this.repaint();
    }

    public void updatePlayer(Player player) {
        this.updatePlayerButtons(player);
        this.rearrangePlayers();
    }

    public void addPlayer(Player player) {
        this.playersEntries[this.numPlayers] = new PlayerEntry(this.graphwar, this.entryWidth, this.entryHeight, player, this.switchNormal, this.switchOver, this.switchMask, this.soldierNormal, this.soldierOver, this.soldierMask, this.removeNormal, this.removeOver, this.removeMask);
        this.add(this.playersEntries[this.numPlayers]);
        this.revalidate();
        ++this.numPlayers;
        this.updatePlayerButtons(player);
        this.rearrangePlayers();
    }

    public void removePlayer(Player player) {
        int n;
        int n2 = -1;
        for (n = 0; n < this.numPlayers; ++n) {
            if (this.playersEntries[n].player != player) continue;
            n2 = n;
            break;
        }
        if (n2 != -1) {
            this.remove(this.playersEntries[n2]);
            for (n = n2; n < this.numPlayers - 1; ++n) {
                this.playersEntries[n] = this.playersEntries[n + 1];
            }
            --this.numPlayers;
            this.rearrangePlayers();
        }
    }

    private void rearrangePlayers() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.numPlayers; ++i) {
            int n3 = 0;
            int n4 = n;
            if (this.playersEntries[i].player.getTeam() == 2) {
                n3 = this.team2Offset;
                n4 = n2;
                n2 += this.entryHeight;
            } else {
                n += this.entryHeight;
            }
            this.playersEntries[i].setBounds(n3, n4, this.entryWidth, this.entryHeight);
        }
        this.repaint();
    }

    public void restartPlayers() {
        this.removeAll();
        this.revalidate();
        this.numPlayers = 0;
    }

    private class PlayerEntry
    extends JPanel
    implements ActionListener,
    MouseListener {
        private Graphwar graphwar;
        public Player player;
        public GraphButton switchSide;
        public GraphButton[] addSoldier;
        public GraphButton removePlayer;
        private int maxNameLength;

        public PlayerEntry(Graphwar graphwar, int n, int n2, Player player, Image image, Image image2, BufferedImage bufferedImage, Image image3, Image image4, BufferedImage bufferedImage2, Image image5, Image image6, BufferedImage bufferedImage3) {
            int n3;
            int n4;
            this.graphwar = graphwar;
            this.setLayout(null);
            this.player = player;
            this.switchSide = new GraphButton(image, image2, bufferedImage);
            this.add(this.switchSide);
            this.addSoldier = new GraphButton[4];
            for (n4 = 0; n4 < this.addSoldier.length; ++n4) {
                this.addSoldier[n4] = new GraphButton(image3, image4, bufferedImage2);
                this.add(this.addSoldier[n4]);
            }
            this.removePlayer = new GraphButton(image5, image6, bufferedImage3);
            this.add(this.removePlayer);
            n4 = n - image5.getWidth(null);
            this.removePlayer.setBounds(n4, 0, image5.getWidth(null), image5.getHeight(null));
            for (n3 = 0; n3 < this.addSoldier.length; ++n3) {
                this.addSoldier[n3].setBounds(n4 -= image3.getWidth(null), 0, image3.getWidth(null), image3.getHeight(null));
            }
            this.switchSide.setBounds(n4 -= image.getWidth(null), 0, image.getWidth(null), image.getHeight(null));
            this.maxNameLength = n4 - 5;
            this.switchSide.addActionListener(this);
            for (n3 = 0; n3 < this.addSoldier.length; ++n3) {
                this.addSoldier[n3].addActionListener(this);
                this.addSoldier[n3].addMouseListener(this);
            }
            this.removePlayer.addActionListener(this);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            if (!this.player.getReady()) {
                graphics.setColor(Color.WHITE);
            } else {
                graphics.setColor(Color.GREEN);
            }
            graphics.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            graphics.setColor(Color.BLACK);
            graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            BufferedImage bufferedImage = new BufferedImage(this.maxNameLength, this.getHeight(), 6);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setFont(new Font("Sans", 0, 14));
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawString(this.player.getName(), 1, this.getHeight() - 2);
            graphics.drawImage(bufferedImage, 0, 0, null);
        }

        private boolean isAddSoldier(Object object) {
            for (int i = 0; i < this.addSoldier.length; ++i) {
                if (this.addSoldier[i] != object) continue;
                return true;
            }
            return false;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.switchSide) {
                this.graphwar.getGameData().switchSide(this.player);
            } else if (actionEvent.getSource() == this.removePlayer) {
                this.graphwar.getGameData().removePlayer(this.player);
            } else if (this.isAddSoldier(actionEvent.getSource())) {
                this.graphwar.getGameData().addSoldier(this.player);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 3 && this.isAddSoldier(mouseEvent.getSource())) {
                this.graphwar.getGameData().removeSoldier(this.player);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

