/*
 * Decompiled with CFR 0.152.
 */
package Graphwar;

import Graphwar.FunctionToken;
import Graphwar.MalformedFunction;
import Graphwar.ValueToken;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PolishNotationFunction {
    private static Random random = new Random();
    private FunctionToken[] function;
    private int readLocation;
    private double var1;
    private double var2;
    private double var3;

    PolishNotationFunction() {
        this.function = new FunctionToken[0];
    }

    PolishNotationFunction(String string) throws MalformedFunction {
        FunctionToken[] functionTokenArray = this.createRegularNotationTokens(string);
        this.function = this.reorderTokensToPolishNotation(functionTokenArray);
        if (this.getValuesNeeded() != 0) {
            throw new MalformedFunction();
        }
    }

    private FunctionToken[] reorderTokensToPolishNotation(FunctionToken[] functionTokenArray) {
        ArrayList<FunctionToken> arrayList = new ArrayList<FunctionToken>(functionTokenArray.length);
        this.reorderRec(arrayList, functionTokenArray, 0, functionTokenArray.length - 1);
        FunctionToken[] functionTokenArray2 = arrayList.toArray(new FunctionToken[0]);
        return functionTokenArray2;
    }

    private boolean reorderRec(List<FunctionToken> list, FunctionToken[] functionTokenArray, int n, int n2) {
        int n3;
        if (n > n2 || n >= functionTokenArray.length) {
            return false;
        }
        int n4 = -1;
        int n5 = Integer.MAX_VALUE;
        int n6 = 0;
        for (n3 = n; n3 <= n2; ++n3) {
            if (functionTokenArray[n3].getType() == 17) {
                ++n6;
                continue;
            }
            if (functionTokenArray[n3].getType() == 18) {
                --n6;
                continue;
            }
            if (n6 >= n5 && (n6 != n5 || n4 != -1 && !this.precedes(functionTokenArray[n3].getType(), functionTokenArray[n4].getType()))) continue;
            n4 = n3;
            n5 = n6;
        }
        if (n4 == -1) {
            return false;
        }
        switch (this.getNumParam(functionTokenArray[n4].getType())) {
            case 0: {
                list.add(functionTokenArray[n4]);
                break;
            }
            case 1: {
                list.add(functionTokenArray[n4]);
                this.reorderRec(list, functionTokenArray, n4 + 1, n2);
                break;
            }
            case 2: {
                list.add(functionTokenArray[n4]);
                n3 = this.reorderRec(list, functionTokenArray, n, n4 - 1) ? 1 : 0;
                if (functionTokenArray[n4].getType() == 1 && n3 == 0) {
                    list.add(new ValueToken(0.0));
                }
                this.reorderRec(list, functionTokenArray, n4 + 1, n2);
            }
        }
        return true;
    }

    private boolean precedes(int n, int n2) {
        return n < n2;
    }

    private List<FunctionToken> adjustImplicitMultiplications(List<FunctionToken> list) {
        ListIterator<FunctionToken> listIterator = list.listIterator();
        FunctionToken functionToken = null;
        if (listIterator.hasNext()) {
            functionToken = listIterator.next();
        } else {
            return list;
        }
        while (listIterator.hasNext()) {
            FunctionToken functionToken2 = listIterator.next();
            if (this.isImplicit(functionToken.getType(), functionToken2.getType())) {
                listIterator.previous();
                listIterator.add(new FunctionToken(3));
                listIterator.next();
            }
            functionToken = functionToken2;
        }
        return list;
    }

    private boolean isImplicit(int n, int n2) {
        return !(n != 16 && n != 13 && n != 14 && n != 15 && n != 18 || n2 != 16 && n2 != 13 && n2 != 14 && n2 != 15 && n2 != 17 && this.getNumParam(n2) != 1);
    }

    private FunctionToken[] createRegularNotationTokens(String string) {
        String string2 = string.toLowerCase();
        string2 = string2.replaceAll("-", "+-");
        string2 = string2.replaceAll("exp", "e^");
        string2 = string2.replaceAll(",", ".");
        Pattern pattern = Pattern.compile("[0-9]*\\.?[0-9]+|\\(|\\)|x|y|y'|\\+|\\*|/|\\^|sqrt|log|abs|sin|sen|cos|tan|tg|-|ln|e|pi");
        Matcher matcher = pattern.matcher(string2);
        int n = string2.length();
        List<FunctionToken> list = new ArrayList<FunctionToken>(n);
        while (matcher.find()) {
            String string3 = string2.substring(matcher.start(0), matcher.end(0));
            try {
                double d = Double.parseDouble(string3);
                list.add(new ValueToken(d));
            }
            catch (Exception exception) {
                if (string3.equals("x")) {
                    list.add(new FunctionToken(13));
                    continue;
                }
                if (string3.equals("y")) {
                    list.add(new FunctionToken(14));
                    continue;
                }
                if (string3.equals("y'")) {
                    list.add(new FunctionToken(15));
                    continue;
                }
                if (string3.equals("+")) {
                    list.add(new FunctionToken(1));
                    continue;
                }
                if (string3.equals("-")) {
                    list.add(new FunctionToken(2));
                    continue;
                }
                if (string3.equals("*")) {
                    list.add(new FunctionToken(3));
                    continue;
                }
                if (string3.equals("/")) {
                    list.add(new FunctionToken(4));
                    continue;
                }
                if (string3.equals("sqrt")) {
                    list.add(new FunctionToken(6));
                    continue;
                }
                if (string3.equals("log")) {
                    list.add(new FunctionToken(7));
                    continue;
                }
                if (string3.equals("abs")) {
                    list.add(new FunctionToken(8));
                    continue;
                }
                if (string3.equals("sin") || string3.equals("sen")) {
                    list.add(new FunctionToken(9));
                    continue;
                }
                if (string3.equals("cos")) {
                    list.add(new FunctionToken(10));
                    continue;
                }
                if (string3.equals("tan") || string3.equals("tg")) {
                    list.add(new FunctionToken(11));
                    continue;
                }
                if (string3.equals("^")) {
                    list.add(new FunctionToken(5));
                    continue;
                }
                if (string3.equals("ln")) {
                    list.add(new FunctionToken(12));
                    continue;
                }
                if (string3.equals("e")) {
                    list.add(new ValueToken(Math.E));
                    continue;
                }
                if (string3.equals("pi")) {
                    list.add(new ValueToken(Math.PI));
                    continue;
                }
                if (string3.equals("(")) {
                    list.add(new FunctionToken(17));
                    continue;
                }
                if (!string3.equals(")")) continue;
                list.add(new FunctionToken(18));
            }
        }
        list = this.adjustImplicitMultiplications(list);
        return list.toArray(new FunctionToken[0]);
    }

    PolishNotationFunction(FunctionToken[] functionTokenArray) {
        this.function = functionTokenArray;
    }

    PolishNotationFunction(PolishNotationFunction polishNotationFunction, int n) {
        this.function = random.nextBoolean() ? this.mutateFineTune(polishNotationFunction, n) : this.mutateRegion(polishNotationFunction, n);
    }

    private FunctionToken[] mutateRegion(PolishNotationFunction polishNotationFunction, int n) {
        int n2;
        int n3 = (int)(5.0 * Math.abs(random.nextGaussian()));
        int n4 = (int)(5.0 * Math.abs(random.nextGaussian()));
        if (n3 > polishNotationFunction.function.length) {
            n3 = polishNotationFunction.function.length;
        }
        int n5 = polishNotationFunction.function.length - n3 + n4;
        FunctionToken[] functionTokenArray = new FunctionToken[n5];
        int n6 = random.nextInt(polishNotationFunction.function.length - n3 + 1);
        for (n2 = 0; n2 < n6; ++n2) {
            functionTokenArray[n2] = polishNotationFunction.function[n2];
        }
        for (n2 = 0; n2 < n4; ++n2) {
            functionTokenArray[n6 + n2] = this.getRandomToken(n);
        }
        for (n2 = 0; n2 < polishNotationFunction.function.length - n3 - n6; ++n2) {
            functionTokenArray[n6 + n4 + n2] = polishNotationFunction.function[n6 + n3 + n2];
        }
        functionTokenArray = this.adjustFunction(functionTokenArray, n);
        return functionTokenArray;
    }

    private FunctionToken[] mutateFineTune(PolishNotationFunction polishNotationFunction, int n) {
        int n2;
        PolishNotationFunction polishNotationFunction2 = polishNotationFunction.makeCopy();
        int n3 = 0;
        for (n2 = 0; n2 < polishNotationFunction2.function.length; ++n2) {
            if (polishNotationFunction2.function[n2].getType() != 16) continue;
            ++n3;
        }
        if (n3 == 0) {
            this.makeRandomFunction(n);
            return this.function;
        }
        n2 = random.nextInt(n3);
        for (int i = 0; i < polishNotationFunction2.function.length; ++i) {
            if (polishNotationFunction2.function[i].getType() != 16) continue;
            if (n2 == 0) {
                if (random.nextBoolean()) {
                    polishNotationFunction2.function[i] = new ValueToken(random.nextGaussian() * 10.2);
                    break;
                }
                polishNotationFunction2.function[i] = new ValueToken(((ValueToken)polishNotationFunction2.function[i]).getValue() * (random.nextGaussian() + 1.0));
                break;
            }
            --n2;
        }
        return polishNotationFunction2.function;
    }

    PolishNotationFunction(PolishNotationFunction polishNotationFunction, PolishNotationFunction polishNotationFunction2, int n) {
        int n2;
        if (random.nextBoolean()) {
            PolishNotationFunction polishNotationFunction3 = polishNotationFunction;
            polishNotationFunction = polishNotationFunction2;
            polishNotationFunction2 = polishNotationFunction3;
        }
        int n3 = (int)(5.0 * Math.abs(random.nextGaussian()));
        int n4 = (int)(5.0 * Math.abs(random.nextGaussian()));
        int n5 = polishNotationFunction.function.length;
        int n6 = polishNotationFunction2.function.length;
        if (n3 > n5) {
            n3 = n5;
        }
        if (n4 > n6) {
            n4 = n6;
        }
        int n7 = random.nextInt(n5 - n3 + 1);
        int n8 = random.nextInt(n6 - n4 + 1);
        int n9 = n5 - n3 + n4;
        this.function = new FunctionToken[n9];
        for (n2 = 0; n2 < n7; ++n2) {
            this.function[n2] = polishNotationFunction.function[n2];
        }
        for (n2 = 0; n2 < n4; ++n2) {
            this.function[n7 + n2] = polishNotationFunction2.function[n8 + n2];
        }
        for (n2 = 0; n2 < n5 - n3 - n7; ++n2) {
            this.function[n7 + n4 + n2] = polishNotationFunction.function[n7 + n3 + n2];
        }
        this.function = this.adjustFunction(this.function, n);
    }

    public PolishNotationFunction makeCopy() {
        PolishNotationFunction polishNotationFunction = new PolishNotationFunction();
        polishNotationFunction.function = new FunctionToken[this.function.length];
        for (int i = 0; i < polishNotationFunction.function.length; ++i) {
            polishNotationFunction.function[i] = this.function[i].getType() == 16 ? new ValueToken(((ValueToken)this.function[i]).getValue()) : new FunctionToken(this.function[i].getType());
        }
        return polishNotationFunction;
    }

    public String getStringFunction() {
        this.readLocation = 0;
        return this.makeString();
    }

    private String makeString() {
        String string = "";
        FunctionToken functionToken = this.function[this.readLocation];
        ++this.readLocation;
        int n = functionToken.getType();
        if (this.isOperation(n)) {
            if (this.getNumParam(n) == 2) {
                string = string + "(" + this.makeString();
                string = string + this.printToken(functionToken);
                string = string + this.makeString() + ")";
            } else if (n == 2) {
                string = string + "(" + this.printToken(functionToken);
                string = string + "(" + this.makeString() + "))";
            } else {
                string = string + this.printToken(functionToken);
                string = string + "(" + this.makeString() + ")";
            }
        } else {
            string = n == 16 && ((ValueToken)functionToken).getValue() < 0.0 ? string + "(" + this.printToken(functionToken) + ")" : string + this.printToken(functionToken);
        }
        return string;
    }

    private String printToken(FunctionToken functionToken) {
        String string = "";
        switch (functionToken.getType()) {
            case 13: {
                string = "x";
                break;
            }
            case 14: {
                string = "y";
                break;
            }
            case 15: {
                string = "y'";
                break;
            }
            case 16: {
                DecimalFormat decimalFormat = new DecimalFormat("#######.##");
                string = decimalFormat.format(((ValueToken)functionToken).getValue());
                break;
            }
            case 1: {
                string = "+";
                break;
            }
            case 2: {
                string = "-";
                break;
            }
            case 3: {
                string = "*";
                break;
            }
            case 4: {
                string = "/";
                break;
            }
            case 6: {
                string = "sqrt";
                break;
            }
            case 7: {
                string = "log";
                break;
            }
            case 8: {
                string = "abs";
                break;
            }
            case 9: {
                string = "sin";
                break;
            }
            case 10: {
                string = "cos";
                break;
            }
            case 11: {
                string = "tan";
                break;
            }
            case 5: {
                string = "^";
                break;
            }
            case 12: {
                string = "ln";
            }
        }
        return string;
    }

    public void makeRandomFunction(int n) {
        int n2 = (int)(10.0 * Math.abs(random.nextGaussian()));
        this.function = new FunctionToken[n2];
        for (int i = 0; i < n2; ++i) {
            this.function[i] = this.getRandomToken(n);
        }
        this.function = this.adjustFunction(this.function, n);
    }

    private int getValuesNeeded() {
        int n = 1;
        for (int i = 0; i < this.function.length; ++i) {
            n = this.isOperation(this.function[i].getType()) ? (n += this.getNumParam(this.function[i].getType()) - 1) : --n;
            if (n != 0 || i + 1 >= this.function.length) continue;
            return -1;
        }
        return n;
    }

    private FunctionToken[] adjustFunction(FunctionToken[] functionTokenArray, int n) {
        int n2;
        int n3 = 1;
        for (n2 = 0; n2 < functionTokenArray.length; ++n2) {
            n3 = this.isOperation(functionTokenArray[n2].getType()) ? (n3 += this.getNumParam(functionTokenArray[n2].getType()) - 1) : --n3;
            if (n3 != 0) continue;
            functionTokenArray = Arrays.copyOf(functionTokenArray, n2 + 1);
            return functionTokenArray;
        }
        n2 = functionTokenArray.length;
        int n4 = n2 + n3;
        functionTokenArray = Arrays.copyOf(functionTokenArray, n4);
        for (int i = n2; i < n4; ++i) {
            functionTokenArray[i] = this.getRandomValueToken(n);
        }
        return functionTokenArray;
    }

    private boolean isOperation(int n) {
        return n >= 1 && n <= 12;
    }

    private int getNumParam(int n) {
        if (n == 2) {
            return 1;
        }
        if (n >= 1 && n <= 5) {
            return 2;
        }
        if (n >= 6 && n <= 12) {
            return 1;
        }
        return 0;
    }

    private FunctionToken getRandomValueToken(int n) {
        FunctionToken functionToken = null;
        if (random.nextDouble() < 0.5) {
            switch (n) {
                case 0: {
                    functionToken = new FunctionToken(13);
                    break;
                }
                case 1: {
                    if (random.nextBoolean()) {
                        functionToken = new FunctionToken(13);
                        break;
                    }
                    functionToken = new FunctionToken(14);
                    break;
                }
                case 2: {
                    functionToken = random.nextInt(3) == 0 ? new FunctionToken(13) : (random.nextBoolean() ? new FunctionToken(14) : new FunctionToken(15));
                }
            }
        } else {
            functionToken = new ValueToken(random.nextGaussian() * 10.2);
        }
        return functionToken;
    }

    private FunctionToken getRandomToken(int n) {
        FunctionToken functionToken = null;
        functionToken = random.nextDouble() < 0.5 ? this.getRandomValueToken(n) : new FunctionToken(this.getRandomOperator());
        return functionToken;
    }

    private char getRandomOperator() {
        char c = '\u0000';
        switch (random.nextInt(19)) {
            case 0: {
                c = '\u0006';
                break;
            }
            case 1: {
                c = '\u0007';
                break;
            }
            case 2: {
                c = '\b';
                break;
            }
            case 3: {
                c = '\t';
                break;
            }
            case 4: {
                c = '\n';
                break;
            }
            case 5: {
                c = '\u000b';
                break;
            }
            case 6: {
                c = '\f';
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                c = '\u0001';
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                c = '\u0003';
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                c = '\u0004';
                break;
            }
            case 17: 
            case 18: {
                c = '\u0005';
            }
        }
        return c;
    }

    public PolishNotationFunction simplifyFunction() {
        this.readLocation = 0;
        List<FunctionToken> list = this.simplifyRec();
        return new PolishNotationFunction(list.toArray(new FunctionToken[0]));
    }

    private List<FunctionToken> simplifyRec() {
        LinkedList<FunctionToken> linkedList = new LinkedList<FunctionToken>();
        FunctionToken functionToken = this.function[this.readLocation];
        ++this.readLocation;
        if (this.getNumParam(functionToken.getType()) == 2) {
            List<FunctionToken> list = this.simplifyRec();
            List<FunctionToken> list2 = this.simplifyRec();
            if (list.size() == 1 && list2.size() == 1) {
                FunctionToken functionToken2 = list.get(0);
                FunctionToken functionToken3 = list2.get(0);
                if (functionToken2.getType() == 16 && functionToken3.getType() == 16) {
                    double d = this.evaluateToken(functionToken, ((ValueToken)functionToken2).getValue(), ((ValueToken)functionToken3).getValue());
                    linkedList.add(new ValueToken(d));
                    return linkedList;
                }
            }
            linkedList.add(functionToken);
            linkedList.addAll(list);
            linkedList.addAll(list2);
            return linkedList;
        }
        if (this.getNumParam(functionToken.getType()) == 1) {
            FunctionToken functionToken4;
            List<FunctionToken> list = this.simplifyRec();
            if (list.size() == 1 && (functionToken4 = list.get(0)).getType() == 16) {
                double d = this.evaluateToken(functionToken, ((ValueToken)functionToken4).getValue(), 0.0);
                linkedList.add(new ValueToken(d));
                return linkedList;
            }
            linkedList.add(functionToken);
            linkedList.addAll(list);
            return linkedList;
        }
        linkedList.add(functionToken);
        return linkedList;
    }

    public double evaluateFunction(double d, double d2, double d3) {
        this.var1 = d;
        this.var2 = d2;
        this.var3 = d3;
        this.readLocation = 0;
        return this.evaluateRec();
    }

    private double evaluateToken(FunctionToken functionToken, double d, double d2) {
        double d3 = 0.0;
        switch (functionToken.getType()) {
            case 13: {
                d3 = this.var1;
                break;
            }
            case 14: {
                d3 = this.var2;
                break;
            }
            case 15: {
                d3 = this.var3;
                break;
            }
            case 16: {
                d3 = ((ValueToken)functionToken).getValue();
                break;
            }
            case 1: {
                d3 = d + d2;
                break;
            }
            case 2: {
                d3 = -d;
                break;
            }
            case 3: {
                d3 = d * d2;
                break;
            }
            case 4: {
                d3 = d / d2;
                break;
            }
            case 6: {
                d3 = Math.sqrt(d);
                break;
            }
            case 7: {
                d3 = Math.log10(d);
                break;
            }
            case 8: {
                d3 = Math.abs(d);
                break;
            }
            case 9: {
                d3 = Math.sin(d);
                break;
            }
            case 10: {
                d3 = Math.cos(d);
                break;
            }
            case 11: {
                d3 = Math.tan(d);
                break;
            }
            case 5: {
                d3 = Math.pow(d, d2);
                break;
            }
            case 12: {
                d3 = Math.log(d);
            }
        }
        return d3;
    }

    private double evaluateRec() {
        FunctionToken functionToken = this.function[this.readLocation];
        ++this.readLocation;
        double d = 0.0;
        switch (functionToken.getType()) {
            case 13: {
                d = this.var1;
                break;
            }
            case 14: {
                d = this.var2;
                break;
            }
            case 15: {
                d = this.var3;
                break;
            }
            case 16: {
                d = ((ValueToken)functionToken).getValue();
                break;
            }
            case 1: {
                d = this.evaluateRec() + this.evaluateRec();
                break;
            }
            case 2: {
                d = -this.evaluateRec();
                break;
            }
            case 3: {
                d = this.evaluateRec() * this.evaluateRec();
                break;
            }
            case 4: {
                d = this.evaluateRec() / this.evaluateRec();
                break;
            }
            case 6: {
                d = Math.sqrt(this.evaluateRec());
                break;
            }
            case 7: {
                d = Math.log10(this.evaluateRec());
                break;
            }
            case 8: {
                d = Math.abs(this.evaluateRec());
                break;
            }
            case 9: {
                d = Math.sin(this.evaluateRec());
                break;
            }
            case 10: {
                d = Math.cos(this.evaluateRec());
                break;
            }
            case 11: {
                d = Math.tan(this.evaluateRec());
                break;
            }
            case 5: {
                d = Math.pow(this.evaluateRec(), this.evaluateRec());
                break;
            }
            case 12: {
                d = Math.log(this.evaluateRec());
            }
        }
        return d;
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < 10; ++i) {
            PolishNotationFunction polishNotationFunction = new PolishNotationFunction();
            PolishNotationFunction polishNotationFunction2 = new PolishNotationFunction();
            polishNotationFunction.makeRandomFunction(2);
            polishNotationFunction2.makeRandomFunction(2);
            PolishNotationFunction polishNotationFunction3 = new PolishNotationFunction(polishNotationFunction, polishNotationFunction2, 2);
            PolishNotationFunction polishNotationFunction4 = new PolishNotationFunction(polishNotationFunction, 2);
            PolishNotationFunction polishNotationFunction5 = new PolishNotationFunction(polishNotationFunction2, 2);
            System.out.println(polishNotationFunction.getStringFunction());
            System.out.println(polishNotationFunction2.getStringFunction());
            System.out.println(polishNotationFunction3.getStringFunction());
            System.out.println(polishNotationFunction4.getStringFunction());
            System.out.println(polishNotationFunction5.getStringFunction());
            System.out.println();
        }
    }
}

