/*
 * Decompiled with CFR 0.152.
 */
package Graphwar;

import GraphServer.Constants;
import Graphwar.GlobalScreen;
import Graphwar.GraphButton;
import Graphwar.GraphTextBox;
import Graphwar.GraphUtil;
import Graphwar.Graphwar;
import Graphwar.Player;
import Graphwar.PlayerBoard;
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class PreGameScreen
extends JPanel
implements ActionListener {
    private Graphwar graphwar;
    private JLabel[] backgroundImages;
    private GraphButton normalFuncButton;
    private GraphButton firstFuncButton;
    private GraphButton secondFuncButton;
    private GraphButton back;
    private GraphButton addLocalPlayer;
    private GraphButton addPCPlayer;
    private GraphButton readyOn;
    private GraphButton readyOff;
    private GraphButton global;
    private JTextField chatField;
    private GraphTextBox chatBox;
    private PlayerBoard playerBoard;
    private JLabel[] backgroundsAddLocal;
    private JTextField nameFieldAddLocal;
    private GraphButton yesButtonAddLocal;
    private GraphButton noButtonAddLocal;
    private boolean addLocalVisible;
    private JLabel[] backgroundsAddPC;
    private JTextField nameFieldAddPC;
    private JTextField levelFieldAddPC;
    private GraphButton yesButtonAddPC;
    private GraphButton noButtonAddPC;
    private boolean addPCVisible;
    private JLabel[] backgroundsShowMessage;
    private GraphButton okButton;
    private JLabel messageLabel;
    private boolean showMessageVisible;
    private static Font font = new Font("Sans", 1, 12);

    public PreGameScreen(Graphwar graphwar, String string) throws InterruptedException, IOException {
        int n;
        this.graphwar = graphwar;
        this.setLayout(null);
        this.setBounds(0, 0, 800, 600);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(graphwar.getClass().getResourceAsStream(string)));
        Stack<Component> stack = new Stack<Component>();
        int n2 = Integer.parseInt(GraphUtil.nextLine(bufferedReader));
        this.backgroundImages = new JLabel[n2];
        for (n = 0; n < n2; ++n) {
            this.backgroundImages[n] = GraphUtil.makeBackgroundImage(graphwar, bufferedReader);
            stack.push(this.backgroundImages[n]);
        }
        this.normalFuncButton = GraphUtil.makeButton(graphwar, bufferedReader);
        this.firstFuncButton = GraphUtil.makeButton(graphwar, bufferedReader);
        this.secondFuncButton = GraphUtil.makeButton(graphwar, bufferedReader);
        this.back = GraphUtil.makeButton(graphwar, bufferedReader);
        this.addLocalPlayer = GraphUtil.makeButton(graphwar, bufferedReader);
        this.addPCPlayer = GraphUtil.makeButton(graphwar, bufferedReader);
        this.readyOn = GraphUtil.makeButton(graphwar, bufferedReader);
        this.readyOff = GraphUtil.makeButton(graphwar, bufferedReader);
        this.global = GraphUtil.makeButton(graphwar, bufferedReader);
        this.chatField = GraphUtil.makeTextField(bufferedReader);
        this.chatBox = GraphUtil.makeTextBox(bufferedReader);
        this.playerBoard = GraphUtil.makePlayerBoard(graphwar, bufferedReader);
        stack.push(this.normalFuncButton);
        stack.push(this.firstFuncButton);
        stack.push(this.secondFuncButton);
        stack.push(this.back);
        stack.push(this.addLocalPlayer);
        stack.push(this.addPCPlayer);
        stack.push(this.readyOn);
        stack.push(this.readyOff);
        stack.push(this.global);
        stack.push(this.chatField);
        stack.push(this.chatBox);
        stack.push(this.playerBoard);
        this.normalFuncButton.addActionListener(this);
        this.firstFuncButton.addActionListener(this);
        this.secondFuncButton.addActionListener(this);
        this.back.addActionListener(this);
        this.addLocalPlayer.addActionListener(this);
        this.addPCPlayer.addActionListener(this);
        this.readyOn.addActionListener(this);
        this.readyOff.addActionListener(this);
        this.global.addActionListener(this);
        this.chatField.addActionListener(this);
        this.firstFuncButton.setVisible(false);
        this.secondFuncButton.setVisible(false);
        this.readyOn.setVisible(false);
        this.global.setVisible(false);
        n2 = Integer.parseInt(GraphUtil.nextLine(bufferedReader));
        this.backgroundsAddLocal = new JLabel[n2];
        for (n = 0; n < n2; ++n) {
            this.backgroundsAddLocal[n] = GraphUtil.makeBackgroundImage(graphwar, bufferedReader);
            stack.push(this.backgroundsAddLocal[n]);
        }
        this.nameFieldAddLocal = GraphUtil.makeTextField(bufferedReader);
        this.yesButtonAddLocal = GraphUtil.makeButton(graphwar, bufferedReader);
        this.noButtonAddLocal = GraphUtil.makeButton(graphwar, bufferedReader);
        stack.push(this.nameFieldAddLocal);
        stack.push(this.yesButtonAddLocal);
        stack.push(this.noButtonAddLocal);
        this.showAddLocal(false);
        this.nameFieldAddLocal.addActionListener(this);
        this.yesButtonAddLocal.addActionListener(this);
        this.noButtonAddLocal.addActionListener(this);
        n2 = Integer.parseInt(GraphUtil.nextLine(bufferedReader));
        this.backgroundsAddPC = new JLabel[n2];
        for (n = 0; n < n2; ++n) {
            this.backgroundsAddPC[n] = GraphUtil.makeBackgroundImage(graphwar, bufferedReader);
            stack.push(this.backgroundsAddPC[n]);
        }
        this.nameFieldAddPC = GraphUtil.makeTextField(bufferedReader);
        this.levelFieldAddPC = GraphUtil.makeTextField(bufferedReader);
        this.yesButtonAddPC = GraphUtil.makeButton(graphwar, bufferedReader);
        this.noButtonAddPC = GraphUtil.makeButton(graphwar, bufferedReader);
        stack.push(this.nameFieldAddPC);
        stack.push(this.levelFieldAddPC);
        stack.push(this.yesButtonAddPC);
        stack.push(this.noButtonAddPC);
        this.showAddPC(false);
        this.nameFieldAddPC.addActionListener(this);
        this.levelFieldAddPC.addActionListener(this);
        this.yesButtonAddPC.addActionListener(this);
        this.noButtonAddPC.addActionListener(this);
        n2 = Integer.parseInt(GraphUtil.nextLine(bufferedReader));
        this.backgroundsShowMessage = new JLabel[n2];
        for (n = 0; n < n2; ++n) {
            this.backgroundsShowMessage[n] = GraphUtil.makeBackgroundImage(graphwar, bufferedReader);
            stack.push(this.backgroundsShowMessage[n]);
        }
        this.okButton = GraphUtil.makeButton(graphwar, bufferedReader);
        this.messageLabel = GraphUtil.makeTextLabel(bufferedReader);
        stack.push(this.okButton);
        stack.push(this.messageLabel);
        this.messageLabel.setFont(new Font("Sans", 1, 20));
        this.messageLabel.setForeground(Color.ORANGE);
        this.messageLabel.setHorizontalAlignment(0);
        this.messageLabel.setVerticalAlignment(0);
        this.showShowMessage(false);
        this.okButton.addActionListener(this);
        this.addComponentsReversed(this, stack);
        this.revalidate();
    }

    public void setMode(int n) {
        switch (n) {
            case 0: {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PreGameScreen.this.normalFuncButton.setVisible(true);
                        PreGameScreen.this.firstFuncButton.setVisible(false);
                        PreGameScreen.this.secondFuncButton.setVisible(false);
                    }
                });
                break;
            }
            case 1: {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PreGameScreen.this.normalFuncButton.setVisible(false);
                        PreGameScreen.this.firstFuncButton.setVisible(true);
                        PreGameScreen.this.secondFuncButton.setVisible(false);
                    }
                });
                break;
            }
            case 2: {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PreGameScreen.this.normalFuncButton.setVisible(false);
                        PreGameScreen.this.firstFuncButton.setVisible(false);
                        PreGameScreen.this.secondFuncButton.setVisible(true);
                    }
                });
            }
        }
    }

    private void showShowMessage(boolean bl) {
        final boolean bl2 = bl;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PreGameScreen.this.okButton.setVisible(bl2);
                PreGameScreen.this.messageLabel.setVisible(bl2);
                for (int i = 0; i < PreGameScreen.this.backgroundsShowMessage.length; ++i) {
                    PreGameScreen.this.backgroundsShowMessage[i].setVisible(bl2);
                }
                PreGameScreen.this.showMessageVisible = bl2;
                PreGameScreen.this.repaint();
            }
        });
    }

    private void showAddPC(boolean bl) {
        final boolean bl2 = bl;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PreGameScreen.this.nameFieldAddPC.setVisible(bl2);
                PreGameScreen.this.levelFieldAddPC.setVisible(bl2);
                PreGameScreen.this.yesButtonAddPC.setVisible(bl2);
                PreGameScreen.this.noButtonAddPC.setVisible(bl2);
                PreGameScreen.this.addPCVisible = bl2;
                for (int i = 0; i < PreGameScreen.this.backgroundsAddPC.length; ++i) {
                    PreGameScreen.this.backgroundsAddPC[i].setVisible(bl2);
                }
            }
        });
    }

    private void showAddLocal(boolean bl) {
        final boolean bl2 = bl;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PreGameScreen.this.nameFieldAddLocal.setVisible(bl2);
                PreGameScreen.this.yesButtonAddLocal.setVisible(bl2);
                PreGameScreen.this.noButtonAddLocal.setVisible(bl2);
                PreGameScreen.this.addLocalVisible = bl2;
                for (int i = 0; i < PreGameScreen.this.backgroundsAddLocal.length; ++i) {
                    PreGameScreen.this.backgroundsAddLocal[i].setVisible(bl2);
                }
            }
        });
    }

    private void addComponentsReversed(JPanel jPanel, Stack<Component> stack) {
        while (!stack.empty()) {
            jPanel.add(stack.pop());
        }
    }

    public void refreshGlobalButton() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (PreGameScreen.this.graphwar.getGlobalClient().isRunning()) {
                    PreGameScreen.this.global.setVisible(true);
                } else {
                    PreGameScreen.this.global.setVisible(false);
                }
                PreGameScreen.this.repaint();
            }
        });
    }

    public void addPlayer(Player player) {
        this.playerBoard.addPlayer(player);
    }

    public void updatePlayer(Player player) {
        this.playerBoard.updatePlayer(player);
    }

    public void removePlayer(Player player) {
        this.playerBoard.removePlayer(player);
    }

    public void refreshBoard() {
        this.playerBoard.updateBoard();
    }

    public void restartScreen() {
        this.chatBox.emptyText();
        this.playerBoard.restartPlayers();
    }

    public void showMessage(String string) {
        this.messageLabel.setText(string);
        this.showShowMessage(true);
    }

    public void addChat(Player player, String string) {
        String string2 = null;
        Color color = null;
        if (player != null) {
            string2 = player.getName();
            color = player.getColor();
        }
        this.chatBox.addText(string2, color, string);
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        graphics.setColor(Constants.BACKGROUND);
        graphics.fillRect(0, 0, 800, 600);
        this.paintInvalidMessage(graphics);
    }

    private void paintInvalidMessage(Graphics graphics) {
        if (this.graphwar.getGlobalClient().isRoomInvalid()) {
            graphics.setColor(Color.RED);
            graphics.setFont(font);
            graphics.drawString("This room can't be reached. Other players will not be able to join.", 5, 380);
            graphics.drawString("Check if the port number you are using is properly forwarded.", 15, 400);
        }
    }

    public void setReadyButtonOn(boolean bl) {
        if (bl) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PreGameScreen.this.readyOn.setVisible(true);
                    PreGameScreen.this.readyOff.setVisible(false);
                    PreGameScreen.this.revalidate();
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PreGameScreen.this.readyOn.setVisible(false);
                    PreGameScreen.this.readyOff.setVisible(true);
                    PreGameScreen.this.revalidate();
                }
            });
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.addLocalVisible) {
            String string;
            if (actionEvent.getSource() == this.noButtonAddLocal) {
                this.showAddLocal(false);
                this.repaint();
            } else if ((actionEvent.getSource() == this.yesButtonAddLocal || actionEvent.getSource() == this.nameFieldAddLocal) && (string = this.nameFieldAddLocal.getText()) != null && string.length() != 0) {
                if (string.length() > 20) {
                    this.nameFieldAddLocal.setText(string.substring(0, 20));
                } else {
                    this.graphwar.getGameData().addPlayer(string);
                    this.showAddLocal(false);
                    this.repaint();
                }
            }
        } else if (this.addPCVisible) {
            if (actionEvent.getSource() == this.noButtonAddPC) {
                this.showAddPC(false);
                this.repaint();
            } else if (actionEvent.getSource() == this.yesButtonAddPC || actionEvent.getSource() == this.nameFieldAddPC || actionEvent.getSource() == this.levelFieldAddPC) {
                try {
                    String string = this.nameFieldAddPC.getText();
                    int n = 0;
                    if (string != null && string.length() != 0) {
                        if (string.length() > 20) {
                            this.nameFieldAddPC.setText(string.substring(0, 20));
                        } else if (this.levelFieldAddPC.getText().compareToIgnoreCase("Over 9000") == 0) {
                            n = 9001;
                            this.graphwar.getGameData().addPC(string, n);
                            this.showAddPC(false);
                            this.repaint();
                        } else {
                            n = Integer.parseInt(this.levelFieldAddPC.getText());
                            if (n > 9000) {
                                this.levelFieldAddPC.setText("Over 9000");
                            } else if (string != null && string.length() != 0) {
                                this.graphwar.getGameData().addPC(string, n);
                                this.showAddPC(false);
                                this.repaint();
                            }
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    String string = this.levelFieldAddPC.getText();
                    boolean bl = true;
                    for (int i = 0; i < string.length(); ++i) {
                        if (string.charAt(i) <= '9' && string.charAt(i) >= '0') continue;
                        bl = false;
                        break;
                    }
                    if (bl) {
                        this.levelFieldAddPC.setText("Over 9000");
                    }
                }
            }
        } else if (this.showMessageVisible) {
            if (actionEvent.getSource() == this.okButton) {
                ((GlobalScreen)this.graphwar.getUI().getScreen(2)).refreshGameButton();
                ((PreGameScreen)this.graphwar.getUI().getScreen(1)).restartScreen();
                if (this.graphwar.getGlobalClient().isRunning()) {
                    this.graphwar.getUI().setScreen(2);
                } else {
                    this.graphwar.getUI().setScreen(0);
                }
                this.graphwar.finishGame();
                this.showShowMessage(false);
            }
        } else if (actionEvent.getSource() == this.addLocalPlayer) {
            this.showAddLocal(true);
            this.repaint();
        } else if (actionEvent.getSource() == this.addPCPlayer) {
            this.nameFieldAddPC.setText(Constants.computerNames[GraphUtil.random.nextInt(Constants.computerNames.length)]);
            int n = (int)(50.0 + 40.0 * GraphUtil.random.nextGaussian());
            if (n < 10) {
                n = 10;
            }
            this.levelFieldAddPC.setText(n + "");
            this.showAddPC(true);
            this.repaint();
        } else if (actionEvent.getSource() == this.chatField) {
            String string = this.chatField.getText();
            if (!string.isEmpty()) {
                this.graphwar.getGameData().sendChatMessage(string);
                this.chatField.setText("");
            }
        } else if (actionEvent.getSource() == this.normalFuncButton || actionEvent.getSource() == this.firstFuncButton || actionEvent.getSource() == this.secondFuncButton) {
            this.graphwar.getGameData().nextMode();
        } else if (actionEvent.getSource() == this.back) {
            this.graphwar.getGameData().disconnect();
            this.graphwar.getGlobalClient().closeRoom();
        } else if (actionEvent.getSource() == this.readyOff) {
            List<Player> list = this.graphwar.getGameData().getPlayers();
            ListIterator<Player> listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                Player player = listIterator.next();
                if (!player.isLocalPlayer()) continue;
                this.graphwar.getGameData().setReady(player, true);
            }
        } else if (actionEvent.getSource() == this.readyOn) {
            List<Player> list = this.graphwar.getGameData().getPlayers();
            ListIterator<Player> listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                Player player = listIterator.next();
                if (!player.isLocalPlayer()) continue;
                this.graphwar.getGameData().setReady(player, false);
            }
        } else if (actionEvent.getSource() == this.global) {
            this.graphwar.getUI().setScreen(2);
        }
    }

    private class AudioPlayer
    implements Runnable {
        private AudioClip audioClip;

        public AudioPlayer(AudioClip audioClip) {
            this.audioClip = audioClip;
            new Thread(this).start();
        }

        @Override
        public void run() {
            this.audioClip.play();
        }
    }
}

