/*
 * Decompiled with CFR 0.152.
 */
package Graphwar;

import Graphwar.GlobalScreen;
import Graphwar.Graphwar;
import Graphwar.Room;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.util.ListIterator;
import javax.swing.JPanel;

public class RoomBoard
extends JPanel
implements MouseMotionListener,
MouseListener {
    private Graphwar graphwar;
    private int width;
    private int minHeight;
    private int height;
    private boolean roomFocused;
    private int focusedRoomNum;
    private final int entryHeight = 20;
    private final Color focusColor = new Color(255, 174, 0, 75);

    public RoomBoard(Graphwar graphwar, int n, int n2) {
        this.graphwar = graphwar;
        this.width = n;
        this.minHeight = n2;
        this.height = n2;
        this.setPreferredSize(new Dimension(n, this.height));
        this.revalidate();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    private void resize() {
        this.height = 20 * this.graphwar.getGlobalClient().getRooms().size();
        if (this.height < this.minHeight) {
            this.height = this.minHeight;
        }
        this.setPreferredSize(new Dimension(this.width, this.height));
        this.revalidate();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.resize();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        graphics.setColor(Color.BLACK);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setFont(new Font("Sans", 1, 14));
        ListIterator<Room> listIterator = this.graphwar.getGlobalClient().getRooms().listIterator();
        int n = 0;
        while (listIterator.hasNext()) {
            Room room = listIterator.next();
            if (this.roomFocused && this.focusedRoomNum == n) {
                graphics2D.setColor(this.focusColor);
                graphics2D.fillRect(0, 20 * n, this.width, 20);
            }
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawString(" " + room.getName(), 0, 20 * (n + 1) - 4);
            String string = "y";
            if (room.getGameMode() == 1) {
                string = "y'";
            } else if (room.getGameMode() == 2) {
                string = "y''";
            }
            graphics2D.drawString(string, this.width - 40, 20 * (n + 1) - 7);
            graphics2D.drawString(room.getNumPlayers() + "/10", this.width - 110, 20 * (n + 1) - 6);
            graphics2D.drawRect(0, 20 * n, this.width, 20);
            ++n;
        }
    }

    @Override
    public synchronized void mouseMoved(MouseEvent mouseEvent) {
        if (this.roomFocused) {
            int n = this.focusedRoomNum;
            this.focusedRoomNum = mouseEvent.getY() / 20;
            if (this.focusedRoomNum != n) {
                this.graphwar.getUI().getScreen(2).repaint();
            }
        } else {
            this.roomFocused = true;
            this.focusedRoomNum = mouseEvent.getY() / 20;
            this.graphwar.getUI().getScreen(2).repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.roomFocused = false;
        this.graphwar.getUI().getScreen(2).repaint();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        int n;
        if (this.graphwar.getGameData().getGameState() == 0 && (n = mouseEvent.getY() / 20) < this.graphwar.getGlobalClient().getRooms().size()) {
            Room room = this.graphwar.getGlobalClient().getRooms().get(n);
            ((GlobalScreen)this.graphwar.getUI().getScreen(2)).showMessage("Connecting...");
            try {
                this.graphwar.joinGame(room.getIp(), room.getPort());
                this.graphwar.getGameData().addPlayer(this.graphwar.getGlobalClient().getLocalPlayerName());
                this.graphwar.getUI().setScreen(1);
            }
            catch (IOException iOException) {
                ((GlobalScreen)this.graphwar.getUI().getScreen(2)).showMessage("Could not connect.");
                this.graphwar.getGameData().disconnect();
                iOException.printStackTrace();
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }
}

