/*
 * Decompiled with CFR 0.152.
 */
package Graphwar;

import GraphServer.Connection;
import Graphwar.GameData;
import java.io.IOException;
import java.net.SocketTimeoutException;

public class ServerConnection
implements Runnable {
    private Connection connection;
    private GameData gameData;
    private boolean running;

    public ServerConnection(GameData gameData, String string, int n) throws IOException {
        this.gameData = gameData;
        this.connection = new Connection(string, n);
        this.running = false;
    }

    public boolean checkTimeout() {
        return System.currentTimeMillis() - this.connection.getLastReceivedTime() > 30000L;
    }

    public boolean checkStayAliveTime() {
        return System.currentTimeMillis() - this.connection.getLastSentTime() > 5000L;
    }

    public void disconnect() {
        this.running = false;
        try {
            this.connection.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void sendMessage(String string) {
        this.connection.sendMessage(string);
    }

    public void sendKeepAlive() {
        this.connection.sendMessage("10");
    }

    @Override
    public void run() {
        this.running = true;
        while (this.running) {
            try {
                String string = this.connection.readMessage();
                if (string == null) {
                    this.gameData.kickFromGame();
                    this.disconnect();
                    continue;
                }
                this.gameData.handleMessage(string);
                if (!this.checkStayAliveTime()) continue;
                this.sendKeepAlive();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                if (this.checkTimeout()) {
                    this.gameData.kickFromGame();
                    this.disconnect();
                    continue;
                }
                this.sendKeepAlive();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.gameData.kickFromGame();
                this.disconnect();
            }
        }
    }
}

